---
id: 672aa7194614b55c16b879a1
title: What Are Absolute Units in CSS, and When Should You Use Them?
challengeType: 19
dashedName: what-are-absolute-units-in-css
---

# --interactive--

As you design your pages, you will work with different properties like widths, heights, padding, margins, and more. When you define these properties, you will need to specify the length units of measurement you want to use.

There are two types of units you can use to define these properties: relative units and absolute units. In this lesson, we will just focus on absolute units.

Absolute length units are of fixed length and are not relative to anything else. Relative means that the length is relative to something else, like the size of the screen or the size of the parent element. We will talk more about relative units in the next few lessons.

The most common absolute unit is the pixel (`px`). Pixels are a fixed-size unit of measurement in CSS, providing precise control over dimensions. This means that 1px is always equal to 1/96th of an inch.

It is important to note that while 1px is standardized as 1/96th of an inch for the purposes of CSS layout, the actual physical size of a pixel may differ depending on the display.

Let's take a look at an example of using pixels to set the width and height for a box:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css" />
<div class="box"></div>
```

```css
.box {
  width: 100px;
  height: 100px;
  background-color: red;
}
```

:::

In this example, we have a red box with a width and height set to `100px`. The dimensions for this box will stay the same regardless of changes pertaining to the screen size.

So, if you are on a device with a small screen, the box will still be `100px` wide. If you are on a large desktop screen, the box will still be `100px` wide.

So, when should you use absolute units like pixels? Well, it depends on the situation. But generally you will use pixels where you need precise control over element dimensions, spacing, and layout. Sometimes you might use pixels for margins, padding, and borders.

Here is an example of using pixels to set the margin for two boxes:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css" />
<div class="box"></div>
<div class="box"></div>
```

```css
.box {
  width: 100px;
  height: 100px;
  background-color: red;
  margin: 10px;
}
```

:::

Remember that margin is the space outside of the box. So, in this example, the box will have a margin of `10px` on all sides.

Other types of absolute units include the following:

- The `in` (inches) unit, which is equal to 96px
- The `cm` (centimeters) unit, which is equal to 25.2/64 of an inch
- The `mm` (millimeters) unit, which is equal to 1/10th of a centimeter
- The `q` (quarter-millimeters) unit, which is equal to 1/40th of a centimeter
- The `pc` (picas) unit, which is equal to 1/6th of an inch
- The `pt` (points) unit, which is equal to 1/72th of an inch

Most of these units will be used for print and not for screens. 

While the most common unit you will use is pixels, it is important to know that the other absolute units exist.

# --questions--

## --text--

What is a pixel?

## --answers--

An absolute fixed-size unit of measurement in CSS, providing precise control over dimensions.

---

A relative unit of measurement in CSS.

### --feedback--

Think about fixed size here.

---

A unit of measurement that is relative to the size of the screen.

### --feedback--

Think about fixed size here.

---

A unit of measurement that is relative to the size of the parent element.

### --feedback--

Think about fixed size here.

## --video-solution--

1

## --text--

What are the two types of units you can use to define properties in CSS?

## --answers--

`margins` and `padding`.

### --feedback--

Review the beginning of this lesson for the answer.

---

`cm` and `mm`.

### --feedback--

Review the beginning of this lesson for the answer.

---

`absolute` and `relative` units.

---

`picas` and `points`.

### --feedback--

Review the beginning of this lesson for the answer.

## --video-solution--

3

## --text--

Which of the following is NOT an absolute unit of measurement in CSS?

## --answers--

pt

### --feedback--

Review the list of absolute units in the end of the lesson.

---

rem

---

in

### --feedback--

Review the list of absolute units in the end of the lesson.

---

px

### --feedback--

Review the list of absolute units in the end of the lesson.

## --video-solution--

2
