---
id: 672995ffdfd2f337f5f215f8
title: How Do You Display Mathematical Equations and Chemical Formulas in HTML?
challengeType: 19
dashedName: how-do-you-display-mathematical-equations-and-chemical-formulas-in-html
---

# --interactive--

The superscript element is used to display a piece of text as a superscript. A superscript is a symbol or letter printed above the normal line of text.

Here is an example using the superscript element to illustrate exponents (to see the previews, enable the interactive editor):

:::interactive_editor

```html
<p>2<sup>2</sup> (2 squared) is 4.</p>
```

:::

In this example, the number 2 is wrapped in `sup` tags to represent the superscript inside the paragraph. In the preview window, you will see that the second number 2 is smaller and slightly higher than the first number 2.

Common use cases for the superscript element would include exponents, superior lettering, and ordinal numbers. Here is an example using the superscript element for superior lettering (to see the previews, enable the interactive editor): 

:::interactive_editor

```html
<p>
  Monseigneur is often written as <strong>M<sup>gr</sup></strong>.
</p>
```

:::

Superior lettering refers to letters written in superscript, usually to indicate abbreviations. The letters `g` and `r` are wrapped inside superscript tags to illustrate the abbreviation in this example.

It is important to note that the superscript element should only be used for typographical reasons. If you want to style a piece of text with a raised baseline, then you should use CSS instead of the superscript element.

To represent chemical equations inside HTML, you would use the subscript element. This element uses a subscript which displays a lowered baseline using smaller text.

Here is an example of using the subscript element to show the chemical representation for carbon dioxide (to see the previews, enable the interactive editor):

:::interactive_editor

```html
<p>CO<sub>2</sub></p>
```

:::

The number two is wrapped inside `sub` tags to illustrate that the character should be a subscript.

Common use cases for the subscript element include chemical formulas, footnotes, and variable subscripts.

# --questions--

## --text--

What is the primary use of the superscript element in HTML?

## --answers--

To display text in a different color.

### --feedback--

Review the beginning of the lesson where the superscript element is discussed.

---

To show text in a smaller font size.

### --feedback--

Review the beginning of the lesson where the superscript element is discussed.

---

To display text as a superscript above the normal line of text.

---

To underline text.

### --feedback--

Review the beginning of the lesson where the superscript element is discussed.

## --video-solution--

3

## --text--

Which of the following is an example of using the superscript element correctly?

## --answers--

`<p>2<sub>2</sub> (2 squared) is 4.</p>`

### --feedback--

The example should represent an exponent with a number displayed above the normal text line.

---

`<p>2<sup>2</sup> (2 squared) is 4.</p>`

---

`<p>2<sul>2</sul> (2 squared) is 4.</p>`

### --feedback--

The example should represent an exponent with a number displayed above the normal text line.

---

`<p>2<sutp>2</sutp> (2 subscript) is 4.</p>`

### --feedback--

The example should represent an exponent with a number displayed above the normal text line.

## --video-solution--

2

## --text--

What should be used instead of the superscript element if you want to style text with a raised baseline for typographical reasons?

## --answers--

The `sub` element.

### --feedback--

This is a styling method rather than a specific HTML element.

---

CSS

---

The `strong` element.

### --feedback--

This is a styling method rather than a specific HTML element.

---

The `em` element.

### --feedback--

This is a styling method rather than a specific HTML element.

## --video-solution--

2
