---
id: 6729963b1ab11638753cf082
title: What Are the U, S, and Ruby Elements Used For, and How Do They Work?
challengeType: 19
dashedName: what-are-the-u-s-and-ruby-elements-used-for
---

# --interactive--

The unarticulated annotation element, or `u` element for short, is used to represent inline text that has non-textual annotation applied.

Here is an example of using the `u` element to highlight various spelling errors:

:::interactive_editor

```html
<p>
  You can use the unarticulated annotation element to highlight
  <u>inccccort</u> <u>spling</u> <u>issses</u>.
</p>
```

:::

In the example, the words `incorrect`, `spelling`, and `issues` are misspelled. The default styling for the `u` element is a black underline underneath the text.

In HTML4, the `u` element was used for styling purposes. But in HTML5, the `u` element should only be used to indicate that text has non-textual annotation applied.

If you want to style a piece of text with an underline, you should use CSS instead of HTML.

The strikethrough element, or `s` element for short, should be used to represent when text is no longer accurate or relevant. Here is an example of using the `s` element to show the cancellation of an activity:

:::interactive_editor

```html
<p><s>Tomorrow's hike will be meeting at noon.</s></p>

<p>Due to unforeseen weather conditions, the hike has been canceled.</p>
```

:::

In this example, the first sentence is crossed out because the hike was canceled due to weather reasons.

The `s` element should never be used to just to show changes to a document. More appropriate elements in that case would be the deleted text element and the inserted text element.

The `ruby` element represents small text shown above or below the main text. It is typically used to show the pronunciation of East Asian characters. Here is the `ruby` element example from the MDN web docs page:

:::interactive_editor

```html
<ruby> 明日 <rp>(</rp><rt>Ashita</rt><rp>)</rp> </ruby>
```

:::

The `rp` element, or ruby fallback parenthesis element, is used as a fallback for browsers lacking support for displaying ruby annotations.

The `rt` element, or ruby text element, is used to indicate text for the ruby annotation. This text is usually used for pronunciation, or translation details in East Asian typography.

While the `ruby` element can be used for other types of annotations, the most common use case is for East Asian typography.

# --questions--

## --text--

What is the `u` element used for?

## --answers--

It's used to display subscripts in chemical formulas.

### --feedback--

Review the beginning of the lesson to see the examples using the `u` element.

---

It's used to represent user input in HTML forms.

### --feedback--

Review the beginning of the lesson to see the examples using the `u` element.

---

It's used to represent inline text that has non-textual annotation applied.

---

It's used to italicize text in HTML.

### --feedback--

Review the beginning of the lesson to see the examples using the `u` element.

## --video-solution--

3

## --text--

What is the `s` element used for?

## --answers--

It's used to represent when text is no longer accurate or relevant.

---

It's used to create navigational aides on websites.

### --feedback--

Think about text that is no longer accurate.

---

It's used to represent copyright information on pages.

### --feedback--

Think about text that is no longer accurate.

---

It's used to represent captions for images.

### --feedback--

Think about text that is no longer accurate.

## --video-solution--

1

## --text--

What is the `ruby` element typically used for?

## --answers--

It's used to write ruby applications.

### --feedback--

Think about how this element can be used to represent certain cultural characters.

---

It's used to create list items on a page.

### --feedback--

Think about how this element can be used to represent certain cultural characters.

---

It's used to apply an underline for text.

### --feedback--

Think about how this element can be used to represent certain cultural characters.

---

It's used to show the pronunciation of East Asian characters.

## --video-solution--

4
