---
id: 672d266034b5242126271995
title: What Is ASCII, and How Does It Work with charCodeAt() and fromCharCode()?
challengeType: 19
dashedName: what-is-ascii-and-how-does-it-work-with-charcodeat-and-fromcharcode
---

# --interactive--

In programming, understanding how characters are represented as numbers is fundamental. This is where ASCII comes in. ASCII, short for American Standard Code for Information Interchange, is a character encoding standard used in computers to represent text. It assigns a numeric value to each character, which is universally recognized by machines.

In this lesson, we will explore what ASCII is, how it works, and how you can use JavaScript methods like `charCodeAt()` and `fromCharCode()` to interact with ASCII values.

ASCII is a system for encoding characters such as letters, digits, and symbols into numerical values. Each character is mapped to a specific number.

For example, the capital letter `A` is represented by the number `65` in ASCII, while the lowercase `a` is represented by `97`. This encoding allows computers to store and manipulate text.

The ASCII standard covers 128 characters including:

- Uppercase and lowercase English letters (A-Z, a-z).
- Numbers (0-9).  
- Common punctuation marks and symbols (!, @, #, and so on).
- Control characters (such as newline and tab).  

In JavaScript, you can easily access the ASCII code of a character using the `charCodeAt()` method. This method is called on a string and returns the ASCII code of the character at a specified index.

Let’s take a look at an example:

:::interactive_editor

```js
let letter = "A";
console.log(letter.charCodeAt(0));  // 65
```

:::

In this example, `A` is the first character of the string, and calling `charCodeAt(0)` returns its ASCII value, `65`.

You can also use this method with other characters to find their ASCII values:

:::interactive_editor

```js
let symbol = "!";
console.log(symbol.charCodeAt(0));  // 33
```

:::

Here, the ASCII code for the exclamation mark `!` is returned as `33`.

While `charCodeAt()` helps you retrieve the ASCII value of a character, the `fromCharCode()` method allows you to do the opposite: convert an ASCII code into its corresponding character.

Let's see this in action:

:::interactive_editor

```js
let char = String.fromCharCode(65);
console.log(char);  //  A
```

:::

In this example, `fromCharCode(65)` converts the ASCII value `65` back to the character `A`.

Another example would be converting the number `97` to its corresponding lowercase letter:

:::interactive_editor

```js
let char = String.fromCharCode(97);
console.log(char);  // a
```

:::

These methods are particularly useful when you need to manipulate or compare characters based on their ASCII values.

For instance, you might use `charCodeAt()` to check if a character is uppercase, lowercase, or a digit by comparing its ASCII value.

On the other hand, `fromCharCode()` can be used to dynamically generate characters from their ASCII codes.

# --questions--

## --text--

What does the `charCodeAt()` method return when used on a string in JavaScript?

## --answers--

The number of characters in the string.

### --feedback--

Think about how characters are represented as numbers in the ASCII system.

---

The index of a character in the string.

### --feedback--

Think about how characters are represented as numbers in the ASCII system.

---

The ASCII value of a character at a specified index.

---

The hexadecimal representation of a character.

### --feedback--

Think about how characters are represented as numbers in the ASCII system.

## --video-solution--

3

## --text--

What will the following code output?

```js
console.log(String.fromCharCode(66));
```

## --answers--

`B`

---

`b`

### --feedback--

Refer to the section of the lesson that discusses `fromCharCode()`.

---

`6`

### --feedback--

Refer to the section of the lesson that discusses `fromCharCode()`.

---

`A`

### --feedback--

Refer to the section of the lesson that discusses `fromCharCode()`.

## --video-solution--

1

## --text--

Which of the following is an example of how ASCII encoding is useful in programming?

## --answers--

To check if a string contains only uppercase letters.

### --feedback--

Think about what you can do when characters are represented by their ASCII numbers.

---

To calculate the length of a string.

### --feedback--

Think about what you can do when characters are represented by their ASCII numbers.

---

To convert a number into a floating-point value.

### --feedback--

Think about what you can do when characters are represented by their ASCII numbers.

---

To manipulate characters based on their numerical values.

## --video-solution--

4
