---
id: 67326c29dcd98fc5ecc49779
title: How Can You Replace Parts of a String with Another?
challengeType: 19
dashedName: how-can-you-replace-parts-of-a-string-with-another
---

# --interactive--

In JavaScript, there are many scenarios where you may need to replace a portion of a string with another string.

For instance, you might need to update user information in a URL, change the formatting of dates, or correct errors in user-generated content.

The `replace()` method in JavaScript allows you to find a specified value (like a word or character) in a string and replace it with another value. The method returns a new string with the replacement and leaves the original unchanged because JavaScript strings are immutable.

Here is the basic syntax:

```js
string.replace(searchValue, newValue);
```

`searchValue` is the value you want to search for in the string. It can be either a string or a regular expression (regex), which describes patterns in text. This allows you to search for and manipulate strings in a flexible and powerful way. You'll learn more about regular expressions in future lessons.

The `newValue` is the value that will replace the `searchValue`. Here's a simple example:

:::interactive_editor

```js
let text = "I love JavaScript!";
console.log(text); // "I love JavaScript!"
let newText = text.replace("JavaScript", "coding");
console.log(newText);  // "I love coding!"
```

:::

In this example, the word `JavaScript` is found within the string and is replaced with `coding`.

The `replace()` method is case-sensitive, meaning that it will only find exact matches of the `searchValue`. For example:

:::interactive_editor

```js
let sentence = "I enjoy working with JavaScript.";
console.log(sentence);  // "I enjoy working with JavaScript."
let updatedSentence = sentence.replace("javascript", "coding");
console.log(updatedSentence);  // "I enjoy working with JavaScript."
```

:::

Here, since `javascript` (with lowercase `j`) does not match `JavaScript` (with uppercase `J`), the replacement is not made.

By default, the `replace()` method will only replace the first occurrence of the `searchValue`. If the value appears multiple times in the string, only the first one will be replaced:

:::interactive_editor

```js
let phrase = "Hello, world! Welcome to the world of coding.";
console.log(phrase);  // "Hello, world! Welcome to the world of coding."
let updatedPhrase = phrase.replace("world", "universe");
console.log(updatedPhrase);  // "Hello, universe! Welcome to the world of coding."
```

:::

Notice that only the first occurrence of `world` is replaced with `universe`.

The `replace()` method in JavaScript is a powerful and flexible tool for string manipulation.

It lets you replace specific parts of a string, whether you're dealing with individual characters, words, or complex patterns using regular expressions.

While it's ideal for straightforward replacements, understanding its case sensitivity and default behavior (like replacing only the first occurrence) can help you use it more effectively.

# --questions--

## --text--

What is the default behavior of the `replace()` method in JavaScript?

## --answers--

It replaces all occurrences of the search value.

### --feedback--

Think about what happens when there are multiple instances of the word you are trying to replace.

---

It replaces only the first occurrence of the search value.

---

It does nothing if the search value is not found.

### --feedback--

Think about what happens when there are multiple instances of the word you are trying to replace.

---

It replaces every other occurrence of the search value.

### --feedback--

Think about what happens when there are multiple instances of the word you are trying to replace.

## --video-solution--

2

## --text--

What will the following code output?

```js
let phrase = "freeCodeCamp is awesome!";
let updatedPhrase = phrase.replace("freecodecamp", "fCC");

console.log(updatedPhrase);
```

## --answers--

`"fcc is awesome!"`

### --feedback--

Remember that the `replace()` method is case-sensitive.

---

`"fCC is awesome!"`

### --feedback--

Remember that the `replace()` method is case-sensitive.

---

`"freeCodeCamp is awesome!"`

---

`undefined`

### --feedback--

Remember that the `replace()` method is case-sensitive.

## --video-solution--

3

## --text--

What will the following code output?

```js
let phrase = "Good morning, morning people!";
let updatedPhrase = phrase.replace("morning", "evening");

console.log(updatedPhrase);
```

## --answers--

`"Good morning, evening people!"`

### --feedback--

Focus on how the `replace()` method handles the first occurrence of the search value.

---

`"Good evening, morning people!"`

---

`"Good evening, evening people!"`

### --feedback--

Focus on how the `replace()` method handles the first occurrence of the search value.

---

`"Good morning, morning people!"`

### --feedback--

Focus on how the `replace()` method handles the first occurrence of the search value.

## --video-solution--

2
