---
id: 67326c15b3b2f0c5827927cc
title: How Can You Extract a Substring from a String?
challengeType: 19
dashedName: how-can-you-extract-a-substring-from-a-string
---

# --interactive--

When working with strings in JavaScript, you often need to extract a portion or substring from a larger string.

For example, you may want to extract part of a word, a specific character sequence, or just a fragment of a sentence.

JavaScript provides several methods for this task, one of the most commonly used being the `slice()` method.

The `slice()` method allows you to extract a portion of a string and returns a new string, without modifying the original string. It takes two parameters: the starting index and the optional ending index.

Here's the basic syntax:

```js
string.slice(startIndex, endIndex);
```

`startIndex` is the position where the extraction starts. `endIndex` is where the extraction ends. If not provided, `slice()` extracts until the end of the string.

Let's look at a simple example of extracting part of a string:

:::interactive_editor

```js
let message = "Hello, world!";
let greeting = message.slice(0, 5);

console.log(greeting);  // Hello
```

:::

In this example, `slice(0, 5)` extracts characters starting from index `0` up to but not including index `5`. As a result, the word `Hello` is extracted.

If you omit the second parameter, `slice()` will extract everything from the start index to the end of the string:

:::interactive_editor

```js
let message = "Hello, world!";
let world = message.slice(7);

console.log(world);  // world!
```

:::

Here, `slice(7)` extracts the string from index `7` to the end of the string, resulting in `world!`.

You can also use negative numbers as indexes. When you use a negative number, it counts backward from the end of the string:

:::interactive_editor

```js
let message = "JavaScript is fun!";
let lastWord = message.slice(-4);

console.log(lastWord);  // fun!
```

:::

In this case, `slice(-4)` extracts the last four characters from the string, giving us `fun!`.

Let's say you want to extract a section from the middle of a string. You can provide both the starting and ending indexes to precisely control which part of the string you want:

:::interactive_editor

```js
let message = "I love JavaScript!";
let language = message.slice(7, 17);

console.log(language);  // JavaScript
```

:::

Here, `slice(7, 17)` extracts the substring starting at index 7 and ending right before index `17`, which is the word `JavaScript`.

The `slice()` method is a powerful tool for extracting parts of a string in JavaScript.

You specify the start and end indexes, and the method returns a new string that contains the extracted portion.

With options for positive, negative, and omitted indexes, you can adapt it to various situations without altering the original string.

# --questions--

## --text--

What will the following code output?

```js
let text = "JavaScript is awesome!";
let result = text.slice(0, 9);

console.log(result);
```

## --answers--

`JavaScript`

### --feedback--

Think about how `slice()` handles the starting and ending indexes.

---

`JavaScrip`

---

`Java`

### --feedback--

Think about how `slice()` handles the starting and ending indexes.

---

`awesome`

### --feedback--

Think about how `slice()` handles the starting and ending indexes.

## --video-solution--

2

## --text--

Which of the following statements about the `slice()` method is correct?

## --answers--

It modifies the original string.

### --feedback--

Focus on what happens to the original string and the returned value.

---

It returns a new string containing the extracted portion.

---

It includes the ending index in the extracted substring.

### --feedback--

Focus on what happens to the original string and the returned value.

---

It cannot work with negative indexes.

### --feedback--

Focus on what happens to the original string and the returned value.

## --video-solution--

2

## --text--

What will the following code return?

```js
let sentence = "Learning JavaScript is fun!";
let extracted = sentence.slice(9, -5);

console.log(extracted);
```

## --answers--

`JavaScript is`

---

`JavaScript`

### --feedback--

Consider how negative indexes are handled in the `slice()` method.

---

`Learning`

### --feedback--

Consider how negative indexes are handled in the `slice()` method.

---

`fun!`

### --feedback--

Consider how negative indexes are handled in the `slice()` method.

## --video-solution--

1
