---
id: 673263d58da27ea7809963bf
title: What Are Template Literals, and What Is String Interpolation?
challengeType: 19
dashedName: what-are-template-literals-and-what-is-string-interpolation
---

# --interactive--

In JavaScript, template literals are a powerful and flexible way to work with strings. Unlike regular strings, which use single (`'`) or double (`"`) quotes, template literals are defined with backticks (`` ` ``).

They allow for easier string manipulation, including embedding variables directly inside a string, a feature known as string interpolation.

Template literals make it easier to create strings that span multiple lines or include expressions (like variables or even JavaScript code) directly within the string.

Here's an example of a template literal:

:::interactive_editor

```js
const name = "Alice";
const greeting = `Hello, ${name}!`;

console.log(greeting);
```

:::

Notice the use of backticks instead of single or double quotes. The `${name}` syntax is an example of string interpolation, where the value of the variable `name` is directly inserted into the string.

String interpolation allows you to embed variables and expressions inside a string. This is a significant improvement over the older method, where you would concatenate strings and variables using the `+` operator.

Here is an example using string concatenation and the plus (`+`) operator:

:::interactive_editor

```js
const name = "Alice";
const age = 25;
const message = "My name is " + name + " and I am " + age + " years old.";
console.log(message); 
```

:::

And here is an example using template literals and string interpolation:

:::interactive_editor

```js
const name = "Alice";
const age = 25;
const message = `My name is ${name} and I am ${age} years old.`;
console.log(message); 
```

:::

As you can see, string interpolation with template literals is much cleaner and easier to read, especially when you're working with multiple variables.

Another great feature of template literals is that they support multiline strings. With regular strings, you would need to use escape characters (`\n`) to create new lines. With template literals, you can simply write the string across multiple lines, and the formatting is preserved:

:::interactive_editor

```js
let poem = `Roses are red,
Violets are blue,
JavaScript is fun,
And so are you.`;

console.log(poem);
```

:::

Another feature of template literals is that they allow you to embed JavaScript expressions directly within the string, like in this example:

:::interactive_editor

```js
const song = "Bohemian Rhapsody";
const score = 9.5;
const highestScore = 10;
const output = `One of my favorite songs is "${song}". I rated it ${
  (score / highestScore) * 100
}%.`;
console.log(output); 
```

:::

Template literals are particularly useful when you need to include variables or expressions in strings, format complex strings, or work with multiline text. They are more concise and readable compared to traditional string concatenation.

# --questions--

## --text--

Which of the following symbols is used to define a template literal?

## --answers--

Single quotes (`'`)

### --feedback--

Template literals require a special symbol not used in regular strings.

---

Double quotes (`"`)

### --feedback--

Template literals require a special symbol not used in regular strings.

---

Backticks (`` ` ``)

---

Square brackets (`[]`)

### --feedback--

Template literals require a special symbol not used in regular strings.

## --video-solution--

3

## --text--

What is string interpolation used for in template literals?

## --answers--

Combining multiple strings without any variables.

### --feedback--

String interpolation helps you avoid concatenation.

---

Inserting variables and expressions directly into a string.

---

Changing the type of a string to a number.

### --feedback--

String interpolation helps you avoid concatenation.

---

Creating functions that manipulate strings.

### --feedback--

String interpolation helps you avoid concatenation.

## --video-solution--

2

## --text--

Which of the following is a feature of template literals that makes them better suited for writing multiline strings compared to regular strings?

## --answers--

Template literals automatically capitalize all letters.

### --feedback--

Consider how regular strings handle new lines.

---

Template literals preserve line breaks without needing escape characters.

---

Template literals allow for mathematical operations on strings.

### --feedback--

Consider how regular strings handle new lines.

---

Template literals require less memory to store strings.

### --feedback--

Consider how regular strings handle new lines.

## --video-solution--

2
