---
id: 673263e80dd43da7df3ae565
title: How Can You Find the Position of a Substring in a String?
challengeType: 19
dashedName: how-can-you-find-the-position-of-a-substring-in-a-string
---

# --interactive--

When working with strings in JavaScript, there may be times when you need to locate the position of a specific substring within a larger string.

A substring is a sequence of characters that appears within a larger string. For example, in the string `hello world`, `hello` and `world` are substrings.

To locate the position of a substring inside of a string, you can use the `indexOf()` method.
The `indexOf()` method in JavaScript allows you to search for a substring within a string.

If the substring is found, `indexOf()` returns the index (or position) of the first occurrence of that substring. If the substring is not found, `indexOf()` returns `-1`, which indicates that the search was unsuccessful.

The `indexOf()` method takes two arguments: the first is the substring you want to find within the larger string, and the second is an option starting position for the search. If you don’t provide a starting position, the search will begin at the start of the string.

In this context, an **argument** is a value you give to a function or method when you call it, enabling that function or method to perform its task using the specific information you provide. You will learn more about arguments in future lessons.

Here is an example of using the `indexOf()` method to find the position for the string `awesome`:

:::interactive_editor

```js
let sentence = "JavaScript is awesome!";
let position = sentence.indexOf("awesome!");
console.log(position); // 14
```

:::

In this example, the word `awesome` starts at index `14` in the string `JavaScript is awesome!`, so the `indexOf()` method returns `14`.

Now, let's see what happens when the substring isn't found:

:::interactive_editor

```js
let sentence = "JavaScript is awesome!";
let position = sentence.indexOf("fantastic");
console.log(position); // -1
```

:::

Since the word `fantastic` does not appear in the string, the method returns `-1`.

You can also specify where to begin searching within the string by providing a second argument to `indexOf()`. Here's an example:

:::interactive_editor

```js
let sentence = "JavaScript is awesome, and JavaScript is powerful!";
let position = sentence.indexOf("JavaScript", 10);
console.log(position); // 27
```

:::

In this case, the search for `JavaScript` begins after the 10th character, and so the second occurrence of `JavaScript` is found at index `27`.

It is important to note that the `indexOf()` method is case sensitive.

In this example, the following would return `-1` because the capital letter `F` is not found in the string `freeCodeCamp`.

:::interactive_editor

```js
console.log("freeCodeCamp".indexOf("F")) // -1
```

:::

Using `indexOf()` can be very useful when you need to check if a substring is present in a string and to determine its position for further operations.

# --questions--

## --text--

What does the `indexOf` method return if the substring is not found in the string?

## --answers--

0

### --feedback--

Think about the special value that indicates an unsuccessful search.

---

The length of the string.

### --feedback--

Think about the special value that indicates an unsuccessful search.

---

-1

---

The position of the first character.

### --feedback--

Think about the special value that indicates an unsuccessful search.

## --video-solution--

3

## --text--

How can you use `indexOf` to search for a substring starting at a specific position within the string?

## --answers--

By using the first argument to specify the starting position.

### --feedback--

Remember, you can pass a second argument to the method to control where the search starts.

---

By using the second argument to specify the starting position.

---

By using an additional method.

### --feedback--

Remember, you can pass a second argument to the method to control where the search starts.

---

By changing the string first.

### --feedback--

Remember, you can pass a second argument to the method to control where the search starts.

## --video-solution--

2

## --text--

What will `indexOf()` return in this example?

```js
const str = "I am learning JavaScript.";
str.indexOf("Javascript");
```

## --answers--

`14`

### --feedback--

Remember that the `indexOf()` method is case sensitive.

---

`2`

### --feedback--

Remember that the `indexOf()` method is case sensitive.

---

`-1`

---

`13`

### --feedback--

Remember that the `indexOf()` method is case sensitive.

## --video-solution--

3
