---
id: 672a4e04a24858778f57ebfe
title: What Are HTML Tables Used For, and What Should They Not Be Used For?
challengeType: 19
dashedName: what-are-html-tables-used-for
---

# --interactive--

HTML tables aren't used as much these days as they used to be. But, as a frontend developer, you should still be familiar with them. Tables are one of the earliest ways devs had for displaying data in a browser way back in the 1990s.

Here's an example of code used to generate a table from the U.S. Bureau of Labor Statistics:

:::interactive_editor

```html
<table id="quickfacts">
  <thead>
    <tr>
      <th colspan="2">Quick Facts: Software Developers, Quality Assurance Analysts, and Testers</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>2023 Median Pay</th>
      <td>
        $130,160 per year
        <br>$62.58 per hour
      </td>
    </tr>
    <tr>
      <th>Typical Entry-Level Education</th>
      <td>Bachelor's degree</td>
    </tr>
    <tr>
      <th>Work Experience in a Related Occupation</th>
      <td>None</td>
    </tr>
    <tr>
      <th>On-the-job Training</th>
      <td>None</td>
    </tr>
    <tr>
      <th>Number of Jobs, 2022</th>
      <td>1,795,300</td>
    </tr>
    <tr>
      <th>Job Outlook, 2022-32</th>
      <td>25% (Much faster than average)</td>
    </tr>
    <tr>
      <th>Employment Change, 2022-32</th>
      <td>451,200</td>
    </tr>
  </tbody>
  <tfoot>
    <tr>
      <th>If this table had a footer it would be here.</th>
    </tr>
  </tfoot>
</table>
```

:::

As you can see, there's a main `table` element with an `id` set to `quickfacts`. Inside it, the table has a table head element, `thead`, table body element, `tbody`, and a table foot element, `tfoot`.

The table head, body, and foot elements can each contain some number of table rows, `tr`. And each table row can contain a table header `th` which labels the data in that row. It can also contain some number of individual data cells, called table data, `td`.

Now, that's a lot of HTML elements. But don't be intimidated – these follow a simple hierarchy.

Here's the simplest table we can create that includes all of these elements:

:::interactive_editor

```html
<table>
  <thead>
    <tr>
      <th>The title of this table</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>First Row</th>
      <td>
        First Data Cell
      </td>
    </tr>
    <tr>
      <th>Second Row</th>
      <td>
        Second Data Cell
      </td>
    </tr>
  </tbody>
  <tfoot>
    <tr>
      <th>The footer of this table, which might contain date of publication, author credits, or other meta information.</th>
    </tr>
  </tfoot>
</table>
```

:::

So as you can see, the data itself is always within a `tr` – and within that `tr` element is a `th` element with a header, and a `td` element with data.

Some websites will choose to use `div`s to build their own tables instead of using the more appropriate `table` element.

While it is possible to display tabular data using generic `div` elements, it is still better to use the `table` element instead.

Many years ago, developers might have used a `table` to position non-data elements on a webpage. This was never considered a best practice. But you may encounter some codebases where tables are still used like this.

Nowadays, developers use CSS flexbox and grid to layout their designs. freeCodeCamp will cover these tools in depth later.

For now, just use HTML tables for their original intended purpose: displaying tabular data.

# --questions--

## --text--

In an HTML table, which elements are contained within a `tr` element?

## --answers--

`thead` and `tfoot`.

### --feedback--

Refer back to the beginning of the lesson where the `tr` element was discussed.

---

`td` and `th`.

---

`table` and `tbody`.

### --feedback--

Refer back to the beginning of the lesson where the `tr` element was discussed.

---

`div` and `span`.

### --feedback--

Refer back to the beginning of the lesson where the `tr` element was discussed.

## --video-solution--

2

## --text--

Which of the following are the main sections of an HTML table?

## --answers--

`table`, `div`, and `span`.

### --feedback--

Refer back to the beginning of the lesson where these elements were discussed.

---

`header`, `section`, and `footer`.

### --feedback--

Refer back to the beginning of the lesson where these elements were discussed.

---

`thead`, `tbody`, and `tfoot`.

---

`article`, `aside`, and `nav`.

### --feedback--

Refer back to the beginning of the lesson where these elements were discussed.

## --video-solution--

3

## --text--

What is the main recommended use of HTML tables today?

## --answers--

Creating page layouts.

### --feedback--

Refer back to the end of the lesson where the recommended use was discussed.

---

Displaying tabular data.

---

Styling with CSS.

### --feedback--

Refer back to the end of the lesson where the recommended use was discussed.

---

Embedding images.

### --feedback--

Refer back to the end of the lesson where the recommended use was discussed.

## --video-solution--

2
