---
id: 672995c9e6f69436dbcccc79
title: How Do Block and Inline Quotes Work in HTML?
challengeType: 19
dashedName: how-do-block-and-inline-quotes-work-in-html
---

# --interactive--

In HTML, quoted elements are used to distinguish quoted text from the surrounding content. This gives the quoted text a format that is easy to identify.

You should use the block quotation element for representing a section quoted from another source. It's mainly used for extended quotations. If the source of the quote has an address, you can cite it with the `cite` attribute. The value of this attribute should be a valid URL. This is an example of a quote within a block quotation element:

:::interactive_editor

```html
<blockquote cite="https://www.freecodecamp.org/news/learn-to-code-book/">
  "Can you imagine what it would be like to be a successful developer? To have built software systems that people rely upon?"
</blockquote>
```

:::

This element has a `cite` attribute. The value of the `cite` attribute is the URL of the source. While this attribute doesn't change the presentation of the block quote, it's very helpful for giving screen readers and search engines more information about the quote. In the browser, you'll see that the text is slightly indented.

If you want to start and end the block quote with quotation marks, you may need to write them explicitly within the text. You can write the text directly within the block quotation element, like I just did, or wrap it within one or more paragraph elements. This is helpful when the text has multiple paragraphs, but you want to keep them within the same block quote. Here's an example with four paragraphs:

:::interactive_editor

```html
<blockquote cite="https://www.freecodecamp.org/news/learn-to-code-book/">
  <p>Build your projects. Show them to your friends. Build projects for your friends.</p>
  <p>Build your network. Help the people you meet along the way. What goes around comes around. You'll get what's coming to you.</p>   
  <p>It is not too late. Life is long.</p>
  <p>You will look back on this moment years from now and be glad you made a move.</p>
</blockquote>
```

:::

All the paragraphs are contained within the same block quotation element, so they are part of the same quotation. You can see that the element has a `cite` attribute with the URL of the source. In the browser, you'll see that the four paragraphs are aligned relative to each other, but they are indented relative to their container.

So far I've been using the `cite` attribute to attribute the source of the quotation, but the attribute doesn't really show the source to the user. It only works behind the scenes.

If you want to attribute the source visually, you can add a citation element, `cite`, outside of the block quotation element. This is different from the `cite` attribute. The citation element is an HTML element that you can use to mark up the title of a referenced creative work like a book article, song, film, website, or research paper. Here's an example:

:::interactive_editor

```html
<div>
  <blockquote cite="https://www.freecodecamp.org/news/learn-to-code-book/">
    Can you imagine what it would be like to be a successful developer? To have built software systems that people rely upon?
  </blockquote>
  <p>—Quincy Larson, <cite>How to Learn to Code and Get a Developer Job [Full Book].</cite></p>
</div>
```

:::

The block quotation element contains quoted text. Below the element you can see a paragraph element with the name of the author, followed by a citation element. The citation element contains the title of the book where the quotation came from.

If you go to the browser, now the source will be clearly visible and see that the quote comes from a book written by Quincy Larson. The title of this book is `How to Learn to Code and Get a Developer Job`.

You should use block quotes like these for long quotations from other sources. But sometimes you will only need to quote a few words within a larger paragraph.

That's exactly what the inline quotation element is for. It's for short inline quotations from other sources. Most modern browsers will add quotation marks around the inline quote automatically when you use this element. This is an example:

:::interactive_editor

```html
<p>
  As Quincy Larson said,
  <q cite="https://www.freecodecamp.org/news/learn-to-code-book/">
    Momentum is everything.
  </q>
</p>
```

:::

You can see a paragraph element that contains text. Part of the text is an inline quote, because it's within the inline quotation element. You can also add a `cite` attribute to attribute the source.

This works exactly the same as it did with the block quotation element. There won't be any visual changes, but it will give screen readers and search engines more information about the quote.

In the browser, you'll see that the quoted text is part of the paragraph and it's surrounded by quotation marks. Most modern browsers will add these quotation marks automatically. 

What's the difference between block quotes and inline quotes? You should use block quotes for extended quotations from other sources and inline quotes for short quotations from other sources that should be part of existing paragraphs.

# --questions--

## --text--

Which HTML element is used for displaying extended quotations from other sources?

## --answers--

`q`

### --feedback--

Analyze the two types of quotation elements. Think about which one displays the quotation as an indented block.

---

`blockquote`

---

`cite`

### --feedback--

Analyze the two types of quotation elements. Think about which one displays the quotation as an indented block.

---

`p`

### --feedback--

Analyze the two types of quotation elements. Think about which one displays the quotation as an indented block.

## --video-solution--

2

## --text--

What is the purpose of the `cite` element in HTML?

## --answers--

To display inline quotations.

### --feedback--

Consider how the `cite` element is used in relation to creative works like books, articles, or films.

---

To specify the source URL of a quotation.

### --feedback--

Consider how the `cite` element is used in relation to creative works like books, articles, or films.

---

To mark up the title of a referenced creative work.

---

To display extended quotations.

### --feedback--

Consider how the `cite` element is used in relation to creative works like books, articles, or films.

## --video-solution--

3

## --text--

Which HTML attribute is used to specify the source of a quotation in a block or inline quotation element?

## --answers--

`href`

### --feedback--

Think about the two types of quotation elements and how you can specify the URL of the source.

---

`src`

### --feedback--

Think about the two types of quotation elements and how you can specify the URL of the source.

---

`title`

### --feedback--

Think about the two types of quotation elements and how you can specify the URL of the source.

---

`cite`

## --video-solution--

4
