---
id: 672995e43674fb3775b9ec5d
title: How Do You Display Addresses in HTML?
challengeType: 19
dashedName: how-do-you-display-addresses-in-html
---

# --interactive--

The contact address element is used to represent contact information for a section on a web page. The `address` element is versatile and can be used for business pages, author pages, personal sites, and more.

When it comes to building out your website's contact sections, you should use the semantic `address` element over a generic element like a `div`.

Here is an example of using the `address` element for a company contact page:

:::interactive_editor

```html
<address>
  <h2>Company Name</h2>
  <p>
    1234 Elm Street<br />
    Springfield, IL 62701<br />
    United States
  </p>
  <p>Phone: <a href="tel:+15555555555">+1 (555) 555-5555</a></p>
  <p>Email: <a href="mailto:contact@company.com">contact@company.com</a></p>
</address>
```

:::

In this example, there is the company name, physical address, phone, and email information. For the physical address, the line break element, `br`, is used to show the division between the street name, city, and country.

For the phone number, we have an anchor element with the `href` value set for telephone numbers. The `tel:+` value inside the `href` attribute creates a clickable link to initiate a phone call on certain devices that support that.

For the email address, another anchor element is used with the `href` value set to a `mailto` link. `mailto` links are used in HTML documents to allow users to open a new email within their preferred email client.

One of the downsides of using a `mailto` link is that users often perceive it as spam. Unfortunately, a lot of spammers will use this option to send emails to users. So just keep that in mind when you're using it.

# --questions--

## --text--

What is the purpose of the `address` element?

## --answers--

It's used to define a section for navigation links.

### --feedback--

The name of this element implies what information should be included inside of it.

---

It's used to represent contact information for a section on a web page.

---

It's used to set the font style for a section of the page.

### --feedback--

The name of this element implies what information should be included inside of it.

---

It's used to group content for styling with CSS.

### --feedback--

The name of this element implies what information should be included inside of it.

## --video-solution--

2

## --text--

What is the `mailto` link used for?

## --answers--

It's used to link to a webpage.

### --feedback--

Review the end of the lesson where there are examples showing how the `mailto` works.

---

It's used to create a file download link.

### --feedback--

Review the end of the lesson where there are examples showing how the `mailto` works.

---

It's used to redirect to another website.

### --feedback--

Review the end of the lesson where there are examples showing how the `mailto` works.

---

It's used to allow users to open a new email within their preferred email client.

## --video-solution--

4

## --text--

What is a downside to using `mailto` links?

## --answers--

These links are a target for spammers to send emails to users.

---

These links automatically create a webpage.

### --feedback--

Think about malicious attackers accessing these links.

---

These links enhance website SEO.

### --feedback--

Think about malicious attackers accessing these links.

---

These links improve website loading speed.

### --feedback--

Think about malicious attackers accessing these links.

## --video-solution--

1
