---
id: 672995f16ed97837b365a9f6
title: How Do You Display Times and Dates in HTML?
challengeType: 19
dashedName: how-do-you-display-times-and-dates-in-html
---

# --interactive--

The `time` element is used to represent a specific moment in time.

Here is an example using the `time` element to represent twenty hundred hours, or eight PM in the evening.

:::interactive_editor

```html
<p>The reservations are for <time datetime="20:00">20:00 </time></p>
```

:::

The `datetime` attribute is used to translate dates and times into a machine-readable format.

This is important, because it helps with search engine results and helps the browser process date and time information more effectively.

The value for the `datetime` attribute must be either a valid year, valid month, valid time, local date, global date, or valid duration string.

Here is another example of using the time element to represent a particular date:

:::interactive_editor

```html
<p>
  The graduation will be on <time datetime="2024-06-15T15:00">June 15</time>
</p>
```

:::

The value for the `datetime` attribute is in the ISO 8601 format. ISO 8601 is an international standard to represent dates and times.

The first part of that value is the year, month and day. The capital T in the value is a separator between the date and time.

The fifteen hundred hours would be three PM in the afternoon.

Whenever you need to represent events, publication dates, or appointments, it is best to use the `time` element.

# --questions--

## --text--

What does the `datetime` attribute in the `time` element help with?

## --answers--

It formats text in bold. 

### --feedback--

The `datetime` attribute represents dates and times for machines.

---

It translates dates and times into a machine-readable format.

---

It adds color to the text.

### --feedback--

The `datetime` attribute represents dates and times for machines.

---

It creates hyperlinks to other pages.

### --feedback--

The `datetime` attribute represents dates and times for machines.

## --video-solution--

2

## --text--

What is the correct format for the `datetime` attribute value according to ISO 8601?

## --answers--

`YYYY-MM-DDTHH:MM:SS`

---

`DD-MM-YYYY HH:MM`

### --feedback--

Review the part of the lesson where ISO 8601 was discussed.

---

`MM-DD-YYYY HH:MM AM/PM`

### --feedback--

Review the part of the lesson where ISO 8601 was discussed.

---

`YYYY/MM/DD HH:MM:SS`

### --feedback--

Review the part of the lesson where ISO 8601 was discussed.

## --video-solution--

1

## --text--

What does the capital 'T' in the ISO 8601 datetime value represent?

## --answers--

The time zone.

### --feedback--

Review the end of the lesson when ISO 8601 was discussed.

---

The separator between date and time.

---

The title of the document.

### --feedback--

Review the end of the lesson when ISO 8601 was discussed.

---

The temperature.

### --feedback--

Review the end of the lesson when ISO 8601 was discussed.

## --video-solution--

2
