---
id: 67336894ae148431a870694d
title: What Is the DOM, and How Do You Access Elements?
challengeType: 19
dashedName: what-is-the-dom-and-how-do-you-access-elements
---

# --interactive--

Let's learn about the DOM and why it's so important for web development. DOM stands for Document Object Model. It's a programming interface that lets us interact with HTML documents.

With the DOM, you can add, modify, or delete elements on a webpage. You can even make your website interactive by making elements listen to and respond to events.

In the DOM, an HTML document is represented as a tree of nodes. Each node represents an HTML element from the HTML document:

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <title>DOM Example</title>
  </head>
  <body>
    <h1>What is the DOM?</h1>
    <h2>Let's learn about the DOM</h2>
  </body>
</html>
```

This is a diagram representing the basic DOM structure of our example:

```md
Document
========

HTML
-----

- Head
  - Title
- Body
  - H1
  - H2   
```

Of course, this can be more detailed and complex based on the structure of the HTML markup of a webpage.

The HTML document is the root node in the DOM hierarchy. It has one child node, the `html` element. This is the root element of the HTML document, since all other nodes descend from it.

The `html` element has two children: `head` and `body`.

The `head` element contains metadata about the document. It provides essential information about the webpage.

The `body` element contains the visible content of the webpage.

You can access these elements with JavaScript, work with them in your code, and even modify them dynamically. That's the power of the DOM and web APIs.

To access these elements in JavaScript, you can use `getElementById()` and `querySelector()` methods. These methods are web APIs because they provide standardized ways to interact with the DOM using JavaScript.

With `getElementById()`, you can get an object that represents the HTML element with the specified `id`. Remember that `id`s must be unique in every HTML document, so this method will only return one `Element` object. Here you can see an example:

```js
const container = document.getElementById("container");
```

This line of JavaScript code gets an element with the `id` value of `container` and assigns that object to a JavaScript constant. You must pass the `id` within quotation marks as an argument. If you log this object to the console, you will see it in the output:

:::interactive_editor

```html
<div id="container">
  <h1>Hello, World!</h1>
  <p>Welcome to learning about the DOM.</p>
</div>
<script src="index.js"></script>
```

```js
const container = document.getElementById("container");
console.log(container); 
```

:::

`querySelector()` is broader than `getElementById()`. With `querySelector()`, you can get the first element in the HTML document that matches the CSS selector passed as argument. 

In this example, you will get the element that matches the `section` selector:

:::interactive_editor

```html
<section>
  <h2>Section Title</h2>
  <p>This is a section of the webpage.</p>
</section>
<script src="index.js"></script>  
```

```js
const sectionEl = document.querySelector("section");
console.log(sectionEl);
```

:::

If you want to select an element by its class name using `querySelector()`, you need to prefix the class name with a dot (`.`). Here's an example:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<div class="highlight">
  <p>This content is highlighted.</p>
</div>
<script src="index.js"></script>
```

```css
body {
  background-color: lightgray;
}

.highlight {
  background-color: yellow;
}
```

```js
const highlightEl = document.querySelector(".highlight");
console.log(highlightEl);
```

:::

You also have other methods to match multiple elements, like `getElementsByClassName()` and `querySelectorAll()`. You'll learn more about them in future lessons.

By understanding how to use web APIs to manipulate the DOM efficiently, you can create powerful and interactive web applications.

# --questions--

## --text--

What is the Document Object Model (DOM)?

## --answers--

A programming language used for web development.

### --feedback--

Think about how the DOM represents the structure of an HTML document.

---

A collection of CSS styles.

### --feedback--

Think about how the DOM represents the structure of an HTML document.

---

A tree-structured representation of an HTML document.

---

A method for creating dynamic web pages.

### --feedback--

Think about how the DOM represents the structure of an HTML document.

## --video-solution--

3

## --text--

Which of the following methods can be used to access an element by its id in JavaScript?

## --answers--

`getElementById()`

---

`getElementsByClassName()`

### --feedback--

Consider how to target a specific element based on its unique identifier.

---

`querySelectorAll()`

### --feedback--

Consider how to target a specific element based on its unique identifier.

---

`createElement()`

### --feedback--

Consider how to target a specific element based on its unique identifier.

## --video-solution--

1

## --text--

What is the primary purpose of the `querySelector()` method?

## --answers--

To create a new element in the DOM.

### --feedback--

Think about how `querySelector()` is used to target an element.

---

To select an element based on a CSS selector.

---

To modify the content of an existing element.

### --feedback--

Think about how `querySelector()` is used to target an element.

---

To remove an element from the DOM.

### --feedback--

Think about how `querySelector()` is used to target an element.

## --video-solution--

2
