---
id: 6733689f9f31dd31e7d9c789
title: How Do DOM Nodes Exist Relative to Each Other in the DOM Tree?
challengeType: 19
dashedName: how-do-dom-nodes-exist-relative-to-each-other-in-the-dom-tree
---

# --description--

Let's learn about DOM nodes and their relationships in the DOM tree.

Just as a real tree has large and small branches connected in a hierarchical structure, DOM nodes also have direct and indirect relationships with one another. We will use this example to illustrate these relationships:

```html
<!DOCTYPE html>
<html>
  <head>
    <title>DOM Tree Example</title>
  </head>
  <body>
    <h1>Heading 1</h1>
    <p>Paragraph 1</p>
    <ul>
      <li>List item 1</li>
      <li>List item 2</li>
    </ul>
  </body>
</html>
```

Let's start at the top. The root of the DOM tree is the `html` element. It's the top-level container for all the content of an HTML document. All other nodes are descendants of this root node.

Then, below the root node, we find other nodes in the hierarchy. A parent node is an element that contains other elements. A child node is an element that is contained within another element.

In this example, the `body` element is the parent of the paragraph element while the paragraph element is a child of the `body` element. These elements are represented as nodes in the DOM tree with the same relationships.

Just like we have parent nodes and child nodes, we also have sibling nodes. Sibling nodes are elements that share the same parent. In our example, two list item elements share the same unordered list parent, so they are siblings. 

Similarly, the `h1` and paragraph elements are siblings because they share the same parent, the `body` element.

We also have indirect relationships across different levels in the hierarchy. Descendant nodes are elements that are contained within another element, either directly or indirectly. An element is considered a descendant of another one if it can be reached by going through the DOM tree downwards from its ancestor.

In our example, the list item `li` elements are descendants of the `body` element, since they are indirectly contained within it.

An ancestor node is an element that is higher up in the DOM tree hierarchy than another element. In our example, the `body` element is an ancestor of the list item `li` elements.

Understanding these relationships is essential for manipulating and navigating the DOM tree using JavaScript.

# --questions--

## --text--

Which of the following is the parent node of the `body` element?

## --answers--

`head` 

### --feedback--

Think about the top-level element that contains all other elements.

---

`html` 

---

`title` 

### --feedback--

Think about the top-level element that contains all other elements.

---

`document`

### --feedback--

Think about the top-level element that contains all other elements.

## --video-solution--

2

## --text--

Three `li` elements within the same `ul` element are considered:

## --answers--

Parent nodes.

### --feedback--

Think about their relationship to each other and their common parent.

---

Child nodes.

### --feedback--

Think about their relationship to each other and their common parent.

---

Sibling nodes.

---

Descendant nodes.

### --feedback--

Think about their relationship to each other and their common parent.

## --video-solution--

3

## --text--

A `p` element contained directly within a `div` is a:

## --answers--

Parent node of the `div`.

### --feedback--

Think about the hierarchical relationship between the elements.

---

Child node of the `div`.

---

Sibling node of the `div`.

### --feedback--

Think about the hierarchical relationship between the elements.

---

Ancestor node of the `div`.

### --feedback--

Think about the hierarchical relationship between the elements.

## --video-solution--

2
