---
id: 673368b1cf26253212a3cfb2
title: What Is the querySelectorAll() Method, and When Should You Use It?
challengeType: 19
dashedName: what-is-the-queryselectorall-method-and-when-should-you-use-it
---

# --description--

Let's learn about the `querySelectorAll()` method. You can use this method to get a list of all the DOM elements that match a specific CSS selector.

This is how you can call the `querySelectorAll()` method:

```js
document.querySelectorAll(selectors);
```

Call it on the `document` object and pass a string with the CSS selectors as an argument. The argument must be a valid CSS selector string. Otherwise, a `SyntaxError` exception will be thrown.

`querySelectorAll()` returns a `NodeList` object, a collection of nodes that match the specified CSS selector.

The list will contain one `Element` object for each element that matches the CSS selectors. If no matches are found, the list will be empty.

The elements will be in the order in which they appear in the HTML document. For example, you can match all elements of a specific type:

```js
document.querySelectorAll("div");
```

All elements with a specific class:

```js
document.querySelectorAll(".rounded");
```

All elements with a specific ID:

```js
document.querySelectorAll("#logo");
```

Or all elements with a specific attribute, like all links that take users to a specific URL:

```js
document.querySelectorAll("a[href='https://www.freecodecamp.org/']");
```

You can also use more complex CSS selectors, like this one, which matches all list items within an unordered list element with the class `ingredients`:

```js
document.querySelectorAll("ul.ingredients li");
```

Since the method will return a collection of nodes, you can assign this collection to a variable and use it in your programs to work with the individual elements, like you can see in this example with the general syntax:

```js
const matches = document.querySelectorAll(selectors); 
```

For example, if you have this unordered list with three list items:

```html
<ul class="ingredients">
  <li>Flour</li>
  <li>Cheese</li>
  <li>Water</li>
</ul>
```

You can call the `querySelectorAll()` method to match all list items within the unordered list with the class `ingredients` and assign the return value to the `matches` constant:

```js
const matches = document.querySelectorAll("ul.ingredients li");
```

This will return a collection of three nodes. Each node represents a list item element:

```js
// NodeList(3)
{
  0: `<li>Flour</li>`,
  1: `<li>Cheese</li>`,
  2: `<li>Water</li>`,
  length: 3,
}
```

You can work with this collection exactly like you would work with any other JavaScript array.

For example, you can show it in the console with `console.log()`:

```js
console.log(matches);
```

You can also check the length of the collection with the `length` property:

```js
console.log(matches.length);
```

The output will be an integer representing the number of nodes in the collection:

```md
3
```

You can also access the individual elements of the collection with their corresponding indices. The first element will be at index `0`:

```js
console.log(matches[0]);
console.log(matches[1]);
console.log(matches[2]);
```

This is the output: 

```html
<li>Flour</li>
<li>Cheese</li>
<li>Water</li>
```

The elements are printed one by one on the console.

You can also iterate over the elements with a `for` loop:

```js
for (let i = 0; i < matches.length; i++) {
  console.log(matches[i]);    
}
```

The output will be exactly the same in this case. But this can be very powerful for working with all the elements of the collection.

The `querySelectorAll()` method in JavaScript is a powerful tool for selecting multiple elements based on their CSS selectors. With this method, you can select specific elements within your web pages and manipulate them as needed.

# --questions--

## --text--

What is the primary purpose of the `querySelectorAll()` method in JavaScript?

## --answers--

To create new elements in the DOM.

### --feedback--

Think about how `querySelectorAll()` is used to target elements.

---

To modify the content of existing elements.

### --feedback--

Think about how `querySelectorAll()` is used to target elements.

---

To select multiple elements based on a CSS selector.

---

To remove elements from the DOM.

### --feedback--

Think about how `querySelectorAll()` is used to target elements.

## --video-solution--

3

## --text--

What type of object does the `querySelectorAll()` method return?

## --answers--

`String`

### --feedback--

Think about the data structure used to represent a collection of elements.

---

`Number`

### --feedback--

Think about the data structure used to represent a collection of elements.

---

`NodeList`

---

`Array`

### --feedback--

Think about the data structure used to represent a collection of elements.

## --video-solution--

3

## --text--

When using `querySelectorAll()` with a string selector, what happens if the selector doesn't match any elements?

## --answers--

An error is thrown.

### --feedback--

Think about the possible outcomes of a `querySelectorAll()` query.

---

A `null` value is returned.

### --feedback--

Think about the possible outcomes of a `querySelectorAll()` query.

---

An empty `NodeList` is returned.

---

The first matching element is returned.

### --feedback--

Think about the possible outcomes of a `querySelectorAll()` query.

## --video-solution--

3
