---
id: 673368ccf52205329b729378
title: What Is the Difference Between innerText, textContent, and innerHTML?
challengeType: 19
dashedName: what-is-the-difference-between-innertext-textcontent-and-innerhtml
---

# --interactive--

Let's learn about `innerText`, `textContent`, and `innerHTML`.

These are properties that you can access in JavaScript to get or change the content of an HTML element. Even if they may look very similar at first, they do have key differences. Choosing the right one depends on your specific use case, so let's dive in.

Let's start with `innerText`.

`innerText` represents the visible text content of the HTML element and its descendants. This property doesn't include hidden text or HTML tags, only rendered text. 

For example, here you can see a `div` element that contains two paragraphs:

```html
<div id="container">
  <p>Hello, World!</p>
  <p>I'm learning JavaScript</p>
</div>
```

If we get a reference to this HTML element in our JavaScript code using `getElementById()`, we can access the `innerText` property of this element:

:::interactive_editor

```html
<div id="container">
  <p>Hello, World!</p>
  <p>I'm learning JavaScript</p>
</div>
<script src="index.js"></script>
```

```js
const container = document.getElementById("container");
console.log(container.innerText);
```

:::

This is the inner text of this element:

```md
Hello, World!
I'm learning JavaScript
```

The property returns a string with the text contained within the element, including text from its descendants.

You should know that `innerText` only returns the text that is visible at the particular moment when the string is requested. If a child element is hidden, its text won't be visible.

This is an example where the second paragraph is hidden:

:::interactive_editor

```html
<div id="container">
  <p>Hello, World!</p>
  <p hidden>I'm learning JavaScript</p>
</div>
```

:::

If we try to log the `innerText` again, now the output won’t have the text of the second paragraph:

:::interactive_editor

```html
<div id="container">
  <p>Hello, World!</p>
  <p hidden>I'm learning JavaScript</p>
</div>
<script src="index.js"></script>
```

```js
const container = document.getElementById("container");
console.log(container.innerText);
```

:::

You can set the `innerText` of an HTML element like this, but this will replace the existing text and add a line break element (`br`) element for every line break:

:::interactive_editor

```html
<div id="container">
  <p>Hello, World!</p>
  <p>I'm learning JavaScript</p>
</div>
<script src="index.js"></script>
```

```js
const container = document.getElementById("container");
container.innerText = "JavaScript is awesome!";
```

:::

Since `innerText` takes visibility into account, getting its value triggers a process called "reflow", that recalculates the position of certain elements on the website. This process can be computationally intensive, so you should avoid triggering it if possible.

Great. Now let's talk about `textContent`. 

`textContent` returns the plain text content of an element, including all the text within its descendants.

The most important difference between `innerText` and `textContent` is that `textContent` always returns the full text content of an HTML element and its descendants, regardless of whether it's visible or hidden.

Here we have the same example in HTML:

```html
<div id="container">
  <p>Hello, World!</p>
  <p>I'm learning JavaScript</p>
</div>
```

If you try to access this property, you'll see the text of the element and its descendants as the output, keeping the indentation and spacing:

:::interactive_editor

```html
<div id="container">
  <p>Hello, World!</p>
  <p>I'm learning JavaScript</p>
</div>
<script src="index.js"></script>
```

```js
const container = document.getElementById("container");
console.log(container.textContent);
```

:::

If an HTML element is not visible, like you can see over here, where we’ve hidden the second paragraph, its text will still be included in this property:

:::interactive_editor

```html
<div id="container">
  <p>Hello, World!</p>
  <p hidden>I'm learning JavaScript</p>
</div>
<script src="index.js"></script>
```

```js
const container = document.getElementById("container");
console.log(container.textContent);
```

:::
  
`textContent` will also include the content of elements like `script` and `style`.

If you try to replace the value of `textContent` on a node, it will remove all its child nodes and replace them with a single text node containing the new string:

:::interactive_editor

```html
<div id="container">
  <p>Hello, World!</p>
  <p hidden>I'm learning JavaScript</p>
</div>
<script src="index.js"></script>
```

```js
const container = document.getElementById("container");
container.textContent = "New content";
```

:::

And finally, let's talk about how `textContent` and `innerText` differs from `innerHTML`.

Remember that with `innerHTML` you can set the inner HTML content of an element. This is helpful for injecting new HTML into the DOM dynamically.

However, remember that this poses a security risk if you don't have control over the string, such as strings containing data entered by the user. If that data is malicious, it can lead to serious security issues.

To avoid this, it's recommended to use the `textContent` property to insert plain text instead.

The `innerText`, `textContent`, and `innerHTML` properties in JavaScript provide different ways to access and manipulate the content of HTML elements. You should understand the differences between these properties if your goal is to work with HTML content in JavaScript effectively.

# --questions--

## --text--

Which of the following properties returns the visible text content of an HTML element, excluding any hidden text or text within hidden elements?

## --answers--

`innerHTML`

### --feedback--

Think about how these properties handle hidden content.

---

`textContent`

### --feedback--

Think about how these properties handle hidden content.

---

`innerText`

---

All of the above.

### --feedback--

Think about how these properties handle hidden content.

## --video-solution--

3

## --text--

Which of the following properties can be used to dynamically inject new HTML content into an element?

## --answers--

`innerHTML`

---

`textContent`

### --feedback--

Think about which property allows you to modify the HTML structure of an element.

---

`innerText`

### --feedback--

Think about which property allows you to modify the HTML structure of an element.

---

None of the above.

### --feedback--

Think about which property allows you to modify the HTML structure of an element.

## --video-solution--

1

## --text--

Which of the following properties returns the plain text content of an element, including all text within child elements, regardless of whether it is visible or hidden?

## --answers--

`innerHTML`

### --feedback--

Think about how these properties handle hidden content.

---

`textContent`

---

`innerText`

### --feedback--

Think about how these properties handle hidden content.

---

All of the above.

### --feedback--

Think about how these properties handle hidden content.

## --video-solution--

2
