---
id: 673368d97e8ce232cdcd6b68
title: How Do You Add and Remove Nodes from the DOM with appendChild() and removeChild()?
challengeType: 19
dashedName: how-do-you-add-and-remove-nodes-from-the-dom-with-appendchild-and-removechild
---

# --interactive--

There will be times where you will need to add or remove nodes from the DOM and there are a couple of Web APIs you can use.

In this lesson, we will cover the `appendChild()` and `removeChild()` methods.

The `appendChild()` method is used to add a node to the end of the list of children of a specified parent node.

Here is the basic syntax for the `appendChild()` method:

```js
parentNode.appendChild(newNode);
```

Let's take a look at an example to better understand how to use the `appendChild()` method.

In this example, we have an unordered list element with an ID of `desserts` inside the HTML. This list contains two list items of `Cake` and `Pie`:

```html
<ul id="desserts">
  <li>Cake</li>
  <li>Pie</li>
</ul>
```

To access that list inside the JavaScript file, we can use the `getElementById()` method:

```js
const dessertsList = document.getElementById("desserts");
```

We have a variable called `dessertsList` that stores the reference to the `ul` element with the ID of `desserts`.

Then we need to create a new list item element using the `createElement()` method:

```js
const dessertsList = document.getElementById("desserts");
const listItem = document.createElement("li");
```

The following code will create a new list item element and store it in a variable called `listItem`.

To add that node to the end of the list of children of the `ul` element, we can use the `appendChild()` method:

```js
const dessertsList = document.getElementById("desserts");
const listItem = document.createElement("li");

dessertsList.appendChild(listItem);
```

If you were to run this code, you will see that a new list item element is added to the end of the list of children of the `ul` element.

:::interactive_editor

```html
<ul id="desserts">
  <li>Cake</li>
  <li>Pie</li>
</ul>
<script src="index.js"></script>
```

```js
const dessertsList = document.getElementById("desserts");
const listItem = document.createElement("li");

dessertsList.appendChild(listItem);
```

:::

The problem is that the new list item element is empty. To add text content to the new list item element, you can use the `textContent` property:

:::interactive_editor

```html
<ul id="desserts">
  <li>Cake</li>
  <li>Pie</li>
</ul>
<script src="index.js"></script>
```

```js
const dessertsList = document.getElementById("desserts");
const listItem = document.createElement("li");

listItem.textContent = "Cookies";
dessertsList.appendChild(listItem);
```

:::

Now the list will show `Cake`, `Pie`, and `Cookies`.

To remove a node from the DOM, you can use the `removeChild()` method.

Here is the basic syntax for the `removeChild()` method:

```js
parentNode.removeChild(childNode);
```

Let's take look at an example where we want to remove that last paragraph element from this `section` element:

```html
<section id="example-section">
  <h2>Example sub heading</h2>
  <p>first paragraph</p>
  <p>second paragraph</p>
</section>
```

We can access the `section` element inside of the JavaScript file using the `getElementById()` method:

```js
const sectionEl = document.getElementById("example-section");
```

Once we have the reference to the `section` element, we can then access that last paragraph using the `querySelector()` method:

```js
const sectionEl = document.getElementById("example-section");
const lastParagraph = document.querySelector("#example-section p:last-of-type");
```

We are using the `:last-of-type` pseudo-class to select the last paragraph element inside the `section` element.

Now that we have the parent and child nodes, we can remove the last paragraph element from the `section` element using the `removeChild()` method:

:::interactive_editor

```html
<section id="example-section">
  <h2>Example sub heading</h2>
  <p>first paragraph</p>
  <p>second paragraph</p>
</section>
<script src="index.js"></script>
```

```js
const sectionEl = document.getElementById("example-section");
const lastParagraph = document.querySelector("#example-section p:last-of-type");

sectionEl.removeChild(lastParagraph);
```

:::

So, when might you want to add or remove nodes from the DOM?

If you're working with dynamic content, you might need to add or remove nodes from the DOM. Real world examples include shopping carts, to-do lists, and social media feeds.

# --questions--

## --text--

What does the `appendChild()` method do?

## --answers--

It removes a node from the DOM.

### --feedback--

Think about where the node is placed relative to its siblings.

---

It adds a node to the end of the list of children of a specified parent node.

---

It replaces an existing node with a new node.

### --feedback--

Think about where the node is placed relative to its siblings.

---

It moves a node to a different location within the DOM.

### --feedback--

Think about where the node is placed relative to its siblings.

## --video-solution--

2

## --text--

How would you add text content to a newly created list item element?

## --answers--

Use the `setText()` method on the new node.

### --feedback--

Consider the property that allows setting the text inside an element.

---

Directly assign a string to the `innerHTML` property of the new node.

### --feedback--

Consider the property that allows setting the text inside an element.

---

Set the `textContent` property of the new node to the desired string.

---

Use the `appendChild()` method with a text node as an argument.

### --feedback--

Consider the property that allows setting the text inside an element.

## --video-solution--

3

## --text--

How can you remove the last paragraph element from a section using JavaScript?

## --answers--

Use `removeChild()` on the section element with the reference to the last paragraph element.

---

Use `deleteChild()` on the section element with the reference to the last paragraph element.

### --feedback--

Think about the method that removes a child node from its parent.

---

Use `detachChild()` on the section element with the reference to the last paragraph element.

### --feedback--

Think about the method that removes a child node from its parent.

---

Use `removeNode()` on the section element with the reference to the last paragraph element.

### --feedback--

Think about the method that removes a child node from its parent.

## --video-solution--

1
