---
id: 673368f272706633516e4873
title: How Do You Add Attributes with setAttribute()?
challengeType: 19
dashedName: how-do-you-add-attributes-with-setattribute
---

# --interactive--

You may be familiar with working with attributes in your HTML and CSS projects. But did you know that you can add attributes to your HTML elements in your JavaScript file?

In this lesson, you will learn how to work with the `setAttribute()` method to add attributes to your HTML elements.

Here is the basic syntax:

```js
setAttribute(attribute, value);
```

Let's take a look at a few examples to better understand how to use the `setAttribute()` method.

In this first example, we have a `p` element inside the HTML:

```html
<p id="para">I am a paragraph</p>
```

To add a `class` attribute we first need to access that `p` element using the `getElementById()` method. Then we can use the `setAttribute()` method to add the `class` attribute and set the value to `my-class`.

We are using `outerHTML` to log the entire HTML element including its attributes.

:::interactive_editor

```html
<p id="para">I am a paragraph</p>
<script src="index.js"></script>
```

```js
const para = document.getElementById("para");
para.setAttribute("class", "my-class");

console.log(`${para.outerHTML}`);
```

:::

If you have an existing attribute on an HTML element, you can update its value using the `setAttribute()` method.

In this example we have a `div` element with a `class` attribute set to `my-class`:

```html
<div class="my-class"></div>
```

To update the `class` attribute value to example, we can use the `setAttribute()` method again:

:::interactive_editor

```html
<div class="my-class"></div>
<script src="index.js"></script>
```

```js
const divEl = document.querySelector(".my-class");
divEl.setAttribute("class", "example");

console.log(`${divEl.outerHTML}`);
```

:::

So, what are some real-world examples of when to use the `setAttribute()` method?

If you were building a dynamic image gallery, you might need to update the `src` attribute of an image element when a user clicks on a thumbnail.

Another example would be if you're dealing with form validation and need to add certain attributes like `required` or `minlength` to an `input` element.

# --questions--

## --text--

What does the `setAttribute()` method do?

## --answers--

It removes an attribute from an HTML element.

### --feedback--

The method is used to modify attributes of existing elements.

---

It changes the text content of an HTML element.

### --feedback--

The method is used to modify attributes of existing elements.

---

It adds a new attribute or updates the value of an existing attribute on an HTML element.

---

It creates a new HTML element.

### --feedback--

The method is used to modify attributes of existing elements.

## --video-solution--

3

## --text--

How can you update the value of an existing attribute using `setAttribute()`?

## --answers--

By directly assigning a new value to the attribute in HTML.

### --feedback--

The method involves accessing the element first and then applying the change.

---

By using `getElementById()` and then setting the attribute value with `setAttribute()`.

---

By modifying the HTML file directly.

### --feedback--

The method involves accessing the element first and then applying the change.

---

By using the `innerHTML` property.

### --feedback--

The method involves accessing the element first and then applying the change.

## --video-solution--

2

## --text--

In which scenario might you use `setAttribute()` in a real-world application?

## --answers--

To add a `class` attribute to a static `div` element without any dynamic interaction.

### --feedback--

Think about situations where dynamic changes to elements are needed based on user actions.

---

To update the `src` attribute of an image element when a user interacts with a thumbnail.

---

To change the text content of a `p` element on page load.

### --feedback--

Think about situations where dynamic changes to elements are needed based on user actions.

---

To modify the style attribute directly within a CSS file.

### --feedback--

Think about situations where dynamic changes to elements are needed based on user actions.

## --video-solution--

2
