---
id: 673369101e5c4a33db0e8a02
title: How Does the removeEventListener Method Work?
challengeType: 19
dashedName: how-does-the-removeeventlistener-method-work
---

# --interactive--

In the previous lesson, you learned how to work with `"click"` and `"input"` events by using the `addEventListener()` method. In this lesson, you will learn how to remove event listeners using the `removeEventListener()` method.

The `removeEventListener()` method is used to remove an event listener that was previously added to an element using the `addEventListener()` method. This is useful when you want to stop listening for a particular event on an element.

Here is the basic syntax for the `removeEventListener()` method:

```js
element.removeEventListener("event", listener);
```

Just like the `addEventListener()` method, the `removeEventListener()` method takes two arguments: the event you want to remove and the listener function that was previously added.

There is also an additional optional third argument that can be passed to the `removeEventListener()` method. This argument can either be the `options` or `useCapture`.

The `options` argument is an object that specifies the options for the event listener, such as whether the event listener should be passive or once. 

The `useCapture` argument is a boolean value that specifies whether the event should be captured during the event propagation phase.

Most of the time, you will only need to pass the event and listener arguments to the `removeEventListener()` method.

Let's take a look at an example to better understand how the `removeEventListener()` method works:

Here is an example with some HTML:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css" />
<h1>Event Listener examples</h1>
<button id="btn">Change background color</button>
```

```css
button {
  background: linear-gradient(135deg, #4da3ff, #007bff);
  color: white;
  border: none;
  padding: 12px 20px;
  border-radius: 8px;
  font-size: 16px;
  font-weight: 500;
  cursor: pointer;
  transition: all 0.25s ease;
  box-shadow: 0 4px 10px rgba(0, 123, 255, 0.2);
}
```

:::

If we want to toggle the background color between grey and blue, then we can use an event listener for that.

We first need to access the `button` element along with the `body` element:

```js
const bodyEl = document.querySelector("body");
const btn = document.getElementById("btn");
```

Then we need to create the function responsible for toggling between the grey and blue colors:

```js
let isBgColorGrey = true;

function toggleBgColor() {
  bodyEl.style.backgroundColor = isBgColorGrey ? "blue" : "grey";
  isBgColorGrey = !isBgColorGrey;
}
```

We are using a boolean variable `isBgColorGrey` to keep track of the current background color. If the background color is grey, then we change it to blue, and vice versa.

Then we need to add an event listener to the `button` element to call the `toggleBgColor` function when the button is clicked:

```js
btn.addEventListener("click", toggleBgColor);
```

Here is the full example so far:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css" />
<h1>Event Listener examples</h1>
<button id="btn">Change background color</button>
<script src="index.js"></script>
```

```css
button {
  background: linear-gradient(135deg, #4da3ff, #007bff);
  color: white;
  border: none;
  padding: 12px 20px;
  border-radius: 8px;
  font-size: 16px;
  font-weight: 500;
  cursor: pointer;
  transition: all 0.25s ease;
  box-shadow: 0 4px 10px rgba(0, 123, 255, 0.2);
}

button:hover {
  background: linear-gradient(135deg, #66b3ff, #3399ff);
  box-shadow: 0 6px 14px rgba(0, 123, 255, 0.3);
  transform: translateY(-2px);
}
```

```js
const bodyEl = document.querySelector("body");
const btn = document.getElementById("btn");

let isBgColorGrey = true;

function toggleBgColor() {
  bodyEl.style.backgroundColor = isBgColorGrey ? "blue" : "grey";
  isBgColorGrey = !isBgColorGrey;
}

btn.addEventListener("click", toggleBgColor);
```

:::


Each time the button is clicked, the background color of the body will change between grey and blue.

We can update the HTML to include a paragraph element that will be used to remove the event listener when hovered over:

```html
<link rel="stylesheet" href="styles.css" />
<h1>Event Listener examples</h1>
<p id="para">MouseOver this text to remove the event listener</p>
<button id="btn">Change background color</button>
<script src="index.js"></script>
```

To remove the event listener when the paragraph is hovered over, we can add an event listener to the paragraph element. We are using the `mouseover` event and passing in a function that removes the event listener from the `button` element:

```js
const para = document.getElementById("para");
const btn = document.getElementById("btn");

para.addEventListener("mouseover", () => {
  btn.removeEventListener("click", toggleBgColor);
});
```

When the paragraph is hovered over, the event listener for the button click event is removed, and the background color will no longer change when the button is clicked.

Here is the full example with the `removeEventListener()` method:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css" />
<h1>Event Listener examples</h1>
<p id="para">MouseOver this text to remove the event listener</p>
<button id="btn">Change background color</button>
<script src="index.js"></script>
```

```css
button {
  background: linear-gradient(135deg, #4da3ff, #007bff);
  color: white;
  border: none;
  padding: 12px 20px;
  border-radius: 8px;
  font-size: 16px;
  font-weight: 500;
  cursor: pointer;
  transition: all 0.25s ease;
  box-shadow: 0 4px 10px rgba(0, 123, 255, 0.2);
}

button:hover {
  background: linear-gradient(135deg, #66b3ff, #3399ff);
  box-shadow: 0 6px 14px rgba(0, 123, 255, 0.3);
  transform: translateY(-2px);
}
```

```js
const bodyEl = document.querySelector("body");
const para = document.getElementById("para");
const btn = document.getElementById("btn");

let isBgColorGrey = true;

function toggleBgColor() {
  bodyEl.style.backgroundColor = isBgColorGrey ? "blue" : "grey";
  isBgColorGrey = !isBgColorGrey;
}

btn.addEventListener("click", toggleBgColor);

para.addEventListener("mouseover", () => {
  btn.removeEventListener("click", toggleBgColor);
});
```

:::

Real world examples of when to use the `removeEventListener()` method include removing event listeners when a modal is closed in a web application or when a user logs out of an application.

# --questions--

## --text--

What is the purpose of the `removeEventListener()` method?

## --answers--

To add a new event listener to an element.

### --feedback--

This method is essential when you want to stop listening for specific events.

---

To remove an event listener that was previously added to an element.

---

To change the properties of an existing event listener.

### --feedback--

This method is essential when you want to stop listening for specific events.

---

To prevent any event listeners from being added.

### --feedback--

This method is essential when you want to stop listening for specific events.

## --video-solution--

2

## --text--

Which arguments are required for the `removeEventListener()` method?

## --answers--

Only the event type.

### --feedback--

Think about what you need to specify to correctly remove an event listener.

---

The event type and the listener function.

---

The event type, listener function, and options.

### --feedback--

Think about what you need to specify to correctly remove an event listener.

---

The event type and options only.

### --feedback--

Think about what you need to specify to correctly remove an event listener.

## --video-solution--

2

## --text--

When might you want to use the `removeEventListener()` method in a real-world application?

## --answers--

When a user logs into the application.

### --feedback--

Consider scenarios where you want to stop listening for events after a certain action.

---

When a user interacts with a button.

### --feedback--

Consider scenarios where you want to stop listening for events after a certain action.

---

When a modal is closed or when a user logs out.

---

When a user refreshes the page.

### --feedback--

Consider scenarios where you want to stop listening for events after a certain action.

## --video-solution--

3
