---
id: 6733691d88e3053414689276
title: What Are Inline Event Handlers, and Why Is It Best Practice to Use addEventListener Instead?
challengeType: 19
dashedName: what-are-inline-event-handlers-and-why-is-it-best-practice-to-use-addeventlistener-instead
---

# --interactive--

In the previous lessons, you learned how to work with events by using the `addEventListener()` method. But there is another, not recommended way, to work with events in JavaScript.

Inline event handlers are special attributes on an HTML element that are used to execute JavaScript code when an event occurs.

Here is an example of a `button` element with an inline click event handler:

:::interactive_editor

```html
<button onclick="alert('Hello World!')">Show alert</button>
```

:::

When the user clicks on the button, the `alert` function is called and an alert dialog is displayed with the message `Hello World!`.

Another way to use inline event handlers is to call a function that is defined in a `script` tag in the HTML document. 

Here is an example of defining a function called `changeBgColor` and calling it from an inline click event handler:

:::interactive_editor

```html
<script>
  function changeBgColor() {
    document.body.style.backgroundColor = "lightblue";
  }
</script>

<button onclick="changeBgColor()">Change background color</button>
```

:::

When the user clicks on the button, the `changeBgColor` function is called and the background color of the page is changed to light blue. While it is possible to use inline event handlers like this, it is not considered a best practice. 

For one reason, inline event handlers can only be used to attach one event listener to an element. If you want to attach multiple event listeners to the same element, you will need to use `addEventListener()`. Another reason is that inline event handlers mix HTML and JavaScript code together, which can make your code harder to read and maintain. It is better to keep your HTML code and JavaScript code separate by using `addEventListener()` to attach event listeners to elements.

Inline event handlers are not recommended for use in modern JavaScript. So, it is best practice to stick with the `addEventListener()` method when working with events in JavaScript.

# --questions--

## --text--

What is an inline event handler?

## --answers--

A method to attach multiple event listeners to an element.

### --feedback--

Think about how inline event handlers are implemented in HTML.

---

An attribute on an HTML element that executes JavaScript code when an event occurs.

---

A way to define functions in a separate JavaScript file.

### --feedback--

Think about how inline event handlers are implemented in HTML.

---

A type of CSS styling for elements.

### --feedback--

Think about how inline event handlers are implemented in HTML.

## --video-solution--

2

## --text--

Why is it considered best practice to use `addEventListener()` instead of inline event handlers?

## --answers--

`addEventListener()` allows you to mix HTML and JavaScript easily.

### --feedback--

Consider the limitations of inline event handlers.

---

Inline event handlers can only attach one event listener to an element.

---

`addEventListener()` is easier to write.

### --feedback--

Consider the limitations of inline event handlers.

---

Inline event handlers are faster than `addEventListener()`.

### --feedback--

Consider the limitations of inline event handlers.

## --video-solution--

2

## --text--

What is a potential drawback of using inline event handlers?

## --answers--

They are faster than using `addEventListener()`.

### --feedback--

Think about how code organization affects readability.

---

They require more lines of code.

### --feedback--

Think about how code organization affects readability.

---

They make code harder to read and maintain by mixing HTML and JavaScript.

---

They can only be used with buttons.

### --feedback--

Think about how code organization affects readability.

## --video-solution--

3
