---
id: 6733693bfce9a43489a355db
title: What Is the DOMContentLoaded Event, and How Does It Work?
challengeType: 19
dashedName: what-is-the-domcontentloaded-event-and-how-does-it-work
---

# --interactive--

The `DOMContentLoaded` event is fired when everything in the HTML document has been loaded and parsed. If you have external stylesheets, or images, the `DOMContentLoaded` event will not wait for those to be loaded. It will only wait for the HTML to be loaded.

This differs from the `load` event, which waits for everything to be loaded, including external stylesheets, images, and so on.

Here is the example syntax for using the `DOMContentLoaded` event:

```js
document.addEventListener("DOMContentLoaded", function () {
  console.log("DOM is loaded.");
});
```

Once the DOM is loaded, the function will be executed and the message `DOM is loaded.` will be logged to the console.

Now, let's take a look at another example using the `DOMContentLoaded` event. In this example, we have an image inside the HTML. To update the image, we can create a function that changes the `src` and `alt` attributes for the image:

:::interactive_editor

```html
<h1>Image Change on DOM Loaded</h1>
<img
  id="example-img"
  src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/relaxing-cat.jpg"
  alt="Cat relaxing"
/>

<script src="index.js"></script>
```

```js
function changeImg() {
  const img = document.getElementById("example-img");
  img.src =
    "https://cdn.freecodecamp.org/curriculum/responsive-web-design-principles/FCCStickers-CamperBot200x200.jpg";
  img.alt = "CamperBot sticker";
  console.log("image was just changed");
}

changeImg();
```

:::

We can then check if the DOM is still loading and add an event listener for the `DOMContentLoaded` event. If the `DOMContentLoaded` event has already fired, we can call the `changeImg` function directly:

```js
if (document.readyState === "loading") {
  document.addEventListener("DOMContentLoaded", changeImg);
} else {
  console.log("DOMContentLoaded has already fired");
  changeImg();
}
```

If you were to run this code, and refresh the page, you would see the image change to the new image after the DOM has loaded. It happens pretty quickly, but you will see a slight flicker as the image changes.

The `DOMContentLoaded` event is useful when you want to run some JavaScript code as soon as the DOM is loaded, but before all the external resources like images and stylesheets are loaded.

# --questions--

## --text--

What does the `DOMContentLoaded` event signify?

## --answers--

All external resources are fully loaded.

### --feedback--

This event does not wait for images or stylesheets.

---

The HTML document has been fully loaded and parsed.

---

The browser has finished rendering the page.

### --feedback--

This event does not wait for images or stylesheets.

---

All images on the page are fully loaded.

### --feedback--

This event does not wait for images or stylesheets.

## --video-solution--

2

## --text--

How does the `DOMContentLoaded` event differ from the `load` event?

## --answers--

`DOMContentLoaded` waits for images to load, while load does not.

### --feedback--

Consider what resources each event waits for.

---

`DOMContentLoaded` fires before all resources are loaded, while load waits for everything.

---

`DOMContentLoaded` can only be used with external scripts.

### --feedback--

Consider what resources each event waits for.

---

There is no difference; they are the same event.

### --feedback--

Consider what resources each event waits for.

## --video-solution--

2

## --text--

In the provided example, what happens if the `DOMContentLoaded` event has already fired when the script runs?

## --answers--

The image will not change at all.

### --feedback--

Think about the conditional check in the code.

---

An error will occur.

### --feedback--

Think about the conditional check in the code.

---

The `changeImg` function will be called directly.

---

The event listener will be added again.

### --feedback--

Think about the conditional check in the code.

## --video-solution--

3
