---
id: 67336956340e8a34fbd5d9f3
title: What Is the requestAnimationFrame() API, and How Can It Be Used to Set Up an Animation Loop?
challengeType: 19
dashedName: what-is-the-requestanimationframe-api-and-how-can-it-be-used-to-set-up-an-animation-loop
---

# --interactive--

Creating smooth animations on a web page can be tricky, especially if you're not sure how to handle timing properly. The great news is that the `requestAnimationFrame()` API makes it easier. 

`requestAnimationFrame()` is a method that allows you to schedule the next step of your animation before the next screen repaint, resulting in a fluid and visually appealing experience.

The next screen repaint refers to the moment when the browser refreshes the visual display of the web page. This happens multiple times per second, typically around 60 times (or 60 frames per second) on most displays.

To use the `requestAnimationFrame()` method, all you need to do is to call it and pass a callback function into it:

```js
requestAnimationFrame(callback);
```

Calling `requestAnimationFrame()` must first occur inside a function that handles the animation, such as `animate()`, along with a function to update the animation, traditionally called `update()`:

```js
function animate() {
 // Update the animation...
 // for example, move an element, change a style, and more.
 update();
 // Request the next frame
 requestAnimationFrame(animate);
}
```

The `update()` function is where the magic happens. Inside it, you get to change whatever you want to animate. For example, updating a style or changing the position of an element:

```js
function update() {
 element.style.transform = `translateX(${position}px)`;
 position += 2;
}
```

What finally kicks off the animation is calling `requestAnimationFrame()` and passing in the `animate` function, this time outside the `animate` function:

```js
requestAnimationFrame(animate);
```

The loop will continue until you stop it.

Now, let's take a look at another example. The HTML for this example is a `div` element with the text `freeCodeCamp is Awesome`. The CSS makes the `div` a rectangle and hides anything that goes out of the viewport on the left or right. The JavaScript code moves the rectangle `2px` to the right at every call of `requestAnimationFrame(animate)` with the `animate` function as a callback:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css" />
<div id="rect" class="rect">freeCodeCamp is Awesome</div>
<script src="index.js"></script>
```

```css
body {
  overflow-x: hidden;
}

.rect {
  display: flex;
  align-items: center;
  justify-content: center;
  width: 400px;
  height: 250px;
  border-radius: 5px;
  background-color: #1b1b32;
  color: #f5f6f7;
  font-size: 2rem;
  position: absolute;
}
```

```js
const rect = document.getElementById("rect");

let position = 0;

function update() {
  // Move the rectangle 2px to the right
  rect.style.left = position + "px";
  position += 2;

  if (position > window.innerWidth) {
    // Move the rectangle just outside the left side of the screen
    position = -rect.offsetWidth;
  }
}

function animate() {
  update();

  //request the next frame
  requestAnimationFrame(animate);
}

// Start the animation
requestAnimationFrame(animate);
```

:::

The result in the browser will be an animated title card floating across the screen.

# --questions--

## --text--

What does the `requestAnimationFrame()` method do?

## --answers--

It stops an animation from running.

### --feedback--

Think about how this method helps create fluid animations.

---

It runs an animation immediately without delay.

### --feedback--

Think about how this method helps create fluid animations.

---

It speeds up an animation.

### --feedback--

Think about how this method helps create fluid animations.

---

It schedules the next step of an animation before the next screen repaint for smoother visuals.

## --video-solution--

4

## --text--

What kicks off the animation when using `requestAnimationFrame()`?

## --answers--

Calling the `animate` function inside the `requestAnimationFrame()` method.

### --feedback--

Think about how the `requestAnimationFrame()` method triggers the animation.

---

Setting a timeout with `setTimeout()`.

### --feedback--

Think about how the `requestAnimationFrame()` method triggers the animation.

---

Using `setInterval()` to repeat the animation.

### --feedback--

Think about how the `requestAnimationFrame()` method triggers the animation.

---

Calling `requestAnimationFrame()` and passing in the animate function outside the animate function.

## --video-solution--

4

## --text--

What does the "next screen repaint" mean?

## --answers--

The moment when the browser updates the HTML structure.

### --feedback--

Think about how often the browser updates what you see on the screen.

---

The moment when the browser refreshes the visual display of the web page, usually around 60 times per second.

---

The moment when the browser reloads the entire page.

### --feedback--

Think about how often the browser updates what you see on the screen.

---

The moment when the browser updates CSS styles.

### --feedback--

Think about how often the browser updates what you see on the screen.

## --video-solution--

2
