---
id: 6733697661182d357fc643d2
title: What Is the Canvas API, and How Does It Work?
challengeType: 19
dashedName: what-is-the-canvas-api-and-how-does-it-work
---

# --interactive--

The `Canvas` API is a powerful tool that lets you manipulate graphics right inside your JavaScript file. Everything begins with a `canvas` element in HTML. This element serves as a drawing surface that you can manipulate using the instance methods and properties of the `Canvas` API.

The `Canvas` API provides everything you need to create amazing visuals, including shapes, text, animations, and even complex games. It has interfaces like `HTMLCanvasElement`, `CanvasRenderingContext2D`, `CanvasGradient`, `CanvasPattern`, `TextMetrics` which provide methods and properties you can use to create graphics in your JavaScript file.

Let's look at how the `Canvas` API works so you can start creating graphics with JavaScript.

First, you need to create a `canvas` element in your HTML file:

```html
<canvas id="my-canvas"></canvas>
```

The `canvas` element is represented by the `HTMLCanvasElement` interface, which provides methods and properties for manipulating it. Additionally, you can use methods and properties from other interfaces in the `Canvas` API.

You can give your `canvas` a `width` and `height` inside the HTML:

```html
<canvas id="my-canvas" width="400" height="400"></canvas>
```

Or you can use the `width` and `height` properties of the `HTMLCanvasElement` interface:

```js
const canvas = document.getElementById("my-canvas");
canvas.width = 400;
canvas.height = 400;
```

For now, you can't see anything on the screen yet. After creating your `canvas` element, the next thing to do is to get access to the drawing context of the canvas with the `getContext()` method of the `HTMLCanvasElement` interface. 

The most common context is `2d`, which allows you to draw in two dimensions:

```js
const canvas = document.getElementById("my-canvas");
const ctx = canvas.getContext('2d');
```

If you log the `ctx` variable to the console, you'll see the methods and properties of `CanvasRenderingContext2D` that you can use to create shapes, colors, lines, and more, along with their default values:

```js
console.log(ctx);
```

Once you have the 2D context, you can start drawing on the canvas.

The `Canvas` API provides several methods and properties for drawing shapes, lines, and text. One of those is the `fillStyle` property, which you can combine with the `fillRect()` method to draw a rectangle or square:

:::interactive_editor

```html
<html>
  <head>
  </head>
  <body>
    <canvas id="my-canvas" width="400" height="400"></canvas>
    <script src="index.js"></script>
  </body>
</html>
```

```js
const canvas = document.getElementById("my-canvas");

const ctx = canvas.getContext("2d");

// Set the background color
ctx.fillStyle = "crimson";

// Draw a rectangle
ctx.fillRect(1, 1, 150, 100);
```

:::

`fillRect` takes 4 number values which represent the x axis, y axis, width, and height, respectively.

There's something on the screen now. You can also draw text or even create an animation. Here's a canvas to represent text:

```html
<canvas id="my-text-canvas" width="300" height="70"></canvas>
```

To finally draw the text, pass the text into the `fillText()` method as the first argument, followed by the values for the x and y axis:

:::interactive_editor

```html
<html>
  <head>
  </head>
  <body>
    <canvas id="my-text-canvas" width="300" height="70"></canvas>
    <script src="index.js"></script>
  </body>
</html>
```

```js
const textCanvas = document.getElementById("my-text-canvas");

const textCanvasCtx = textCanvas.getContext("2d");

// Set font family and size
textCanvasCtx.font = "30px Arial";

// Set text color
textCanvasCtx.fillStyle = "crimson";

// Draw the text
textCanvasCtx.fillText("Hello HTML Canvas!", 1, 50);
```

:::

The result in the browser will be the red text `Hello HTML Canvas!`.

These's much more you can do with the `Canvas` API. For example, you can combine it with `requestAnimationFrame` to create custom animations, visualizations, games, and more.

# --questions--

## --text--

Which method and property let you draw and fill rectangles or squares in the `Canvas` API?

## --answers--

`strokeRect()` and `lineWidth`.

### --feedback--

Think about both the method that draws the shape and the property that fills it with color.

---

`fillRect()` and `fillStyle`.

---

`clearRect()` and `strokeStyle`.

### --feedback--

Think about both the method that draws the shape and the property that fills it with color.

---

`beginPath()` and `shadowColor`.

### --feedback--

Think about both the method that draws the shape and the property that fills it with color.

## --video-solution--

2

## --text--

Which of these is not a property or method of the `CanvasRenderingContext2D` interface in the `Canvas` API?

## --answers--

`fillStyle`

### --feedback--

Think about the properties and methods commonly used in canvas rendering.

---

`shadowColor`

### --feedback--

Think about the properties and methods commonly used in canvas rendering.

---

`drawImage`

### --feedback--

Think about the properties and methods commonly used in canvas rendering.

---

`backgroundColor`

## --video-solution--

4

## --text--

How do you draw text on a canvas using the `fillText()` method in JavaScript?

## --answers--

Pass the text, followed by the values for the width and height.

### --feedback--

Think about the coordinates where the text should appear.

---

Pass the text, followed by the values for the x and y axis.

---

Pass the text and font size.

### --feedback--

Think about the coordinates where the text should appear.

---

Pass the text and color values.

### --feedback--

Think about the coordinates where the text should appear.

## --video-solution--

2
