---
id: 673369829e232835c2732656
title: How Do You Open and Close Dialog Elements Using JavaScript?
challengeType: 19
dashedName: how-do-you-open-and-close-dialog-elements-using-javascript
---

# --interactive--

Dialogs let you display important information or actions to users. With HTML's built-in `dialog` element, you can easily create these dialogs (both modal and non-modal dialogs) in your web apps.

A modal dialog is a type of dialog that forces the user to interact with it before they can access the rest of the application or webpage. It effectively blocks interaction with other content until the user completes an action, such as closing the dialog or submitting a form.

In contrast, a non-modal dialog allows the user to continue interacting with other parts of the page or application even when the dialog is open. It doesn't prevent access to the rest of the content.

In this lesson, you will learn how to open and close modals using the `showModal()` and `close()` methods.

When you want to make sure the user focuses on a specific action or message of a modal, you can open the modal dialog using the `showModal()` method. This will add a backdrop to the other items on the page and disable them. This is ideal for modals that display forms, confirmations, and critical information that requires user action. 

Here's the HTML for the modal dialog:

:::interactive_editor

```html
<dialog id="my-modal">
  <p>This is a modal dialog.</p>
</dialog>
```

:::

For now, you can't see anything on the page because the modal is closed on the initial render. You can automatically open the modal by using the `showModal()` method:

:::interactive_editor

```html
<dialog id="modal">
  <p>This is a modal dialog.</p>
</dialog>
<script src="index.js"></script>
```

```js
const dialog = document.getElementById("modal");
dialog.showModal();
```

:::

The result in the browser will show a modal with the text `This is a modal dialog.`

It's best to give control to the user. To achieve this, you can add a click event listener to a button and use the `showModal()` method:

:::interactive_editor

```html
<dialog id="modal">
  <p>This is a modal dialog.</p>
</dialog>
<button id="open-modal-btn">Open Modal Dialog</button>
<script src="index.js"></script>
```

```js
const dialog = document.getElementById("modal");
const openButton = document.getElementById("open-modal-btn");

openButton.addEventListener("click", () => {
  dialog.showModal();
});
```

:::

If you needed to show a dialog while still allowing interaction with content outside of the dialog, then you can use the `show()` method:

:::interactive_editor

```html
<dialog id="modal">
  <p>This is a modal dialog.</p>
</dialog>
<button id="open-modal-btn">Open Modal Dialog</button>
<script src="index.js"></script>
```

```js
const dialog = document.getElementById("modal");
const openButton = document.getElementById("open-modal-btn");

openButton.addEventListener("click", () => {
  dialog.show();
});
```

:::

To close a modal, you can add a button to the modal inside the `dialog` element and use the `close()` method:

:::interactive_editor

```html
<dialog id="modal">
  <p>This is a modal dialog.</p>
  <button id="close-modal-btn">Close Modal</button>
</dialog>
<button id="open-modal-btn">Open Modal Dialog</button>
<script src="index.js"></script>
```

```js
const dialog = document.getElementById("modal");
const openButton = document.getElementById("open-modal-btn");
const closeButton = document.getElementById("close-modal-btn");

openButton.addEventListener("click", () => {
  dialog.show();
});

closeButton.addEventListener("click", () => {
  dialog.close();
});
```

:::

# --questions--

## --text--

What is the difference between a modal dialog and a non-modal dialog?

## --answers--

A modal dialog allows interaction with the rest of the page, while a non-modal dialog doesn't.

### --feedback--

Think about which type of dialog restricts the user's focus.

---

A modal dialog disables interaction with the rest of the page, while a non-modal dialog allows it.

---

A non-modal dialog forces the user to interact with it.

### --feedback--

Think about which type of dialog restricts the user's focus.

---

A modal dialog closes automatically, while a non-modal dialog requires user action to close.

### --feedback--

Think about which type of dialog restricts the user's focus.

## --video-solution--

2

## --text--

Which methods are used to open a modal in JavaScript?

## --answers--

`open()` and `display()`.

### --feedback--

Think about the methods specifically designed for modals.

---

`displayModal()` and `activate()`.

### --feedback--

Think about the methods specifically designed for modals.

---

`launch()` and `trigger()`.

### --feedback--

Think about the methods specifically designed for modals.

---

`showModal()` and `show()`.

## --video-solution--

4

## --text--

How do you execute the `show()`, `close()`, and `showModal()` methods to open and close a modal?

## --answers--

By calling the methods directly without any event.

### --feedback--

Think about how user interaction triggers these methods.

---

By linking them to form submission events.

### --feedback--

Think about how user interaction triggers these methods.

---

By adding a click event listener to a button and using the appropriate method.

---

By using a timeout function.

### --feedback--

Think about how user interaction triggers these methods.

## --video-solution--

3
