---
id: 6732c68f4520d160584a6fd2
title: What Is the toString() Method, and How Does It Work?
challengeType: 19
dashedName: what-is-the-tostring-method-and-how-does-it-work
---

# --interactive--

The `toString()` method is a fundamental feature in JavaScript that converts a value to its string representation. It's a method you can use for numbers, booleans, arrays, and objects. One of the most common uses of `toString()` is to convert a number to its string representation. Here's an example:

:::interactive_editor

```js
const num = 10;
console.log(num.toString()); // "10"
```

:::

This method accepts an optional radix which is a number from `2` to `36`. This radix represents the base, such as base 2 for binary or base 8 for octal. If the radix is not specified it defaults to base 10, which is decimal. Here's an example of passing `2` as an argument to the `toString()` method:

:::interactive_editor

```js
const num = 10;
console.log(num.toString(2)); // "1010"
```

:::

The result will be `1010` which is the binary representation for the decimal number `10`.

You can also use the `toString()` method to convert arrays and objects to strings. Arrays have a custom implementation of `toString()` that converts each element to a string and joins them with commas. Here's an example:

:::interactive_editor

```js
const arr = [1, 2, 3];
console.log(arr.toString()); // "1,2,3"
```

:::

In this example all the elements of the array are joined together to form the string `1,2,3`. 

When `toString()` method is used with objects, the result will not be a stringified version of the object properties. 

:::interactive_editor

```js
const person = {
  name: "John",
  age: 30,
  isStudent: true
};

console.log(person.toString()); // "[object Object]"
```

:::

In this example, the result will be the default string representation for the object which is `[object Object]`. To get a stringified version of the `person` object properties you'll need to use `JSON.stringify()` which you will learn about more in the future lessons.

In conclusion, the `toString()` method is used for converting values to strings. Understanding how it works with different data types and how to customize it for your own objects can greatly advance your ability to manipulate and display data in your JavaScript applications.

# --questions--

## --text--

What will be the output of the following code?

```js
let num = 5.7;
console.log(num.toString());
```

## --answers--

`"5"`

### --feedback--

The `toString()` method is used to convert a value to its string representation.

---

`"5.7"`

---

`5.7`

### --feedback--

The `toString()` method is used to convert a value to its string representation.

---

`Error`

### --feedback--

The `toString()` method is used to convert a value to its string representation.

## --video-solution--

2

## --text--

What will be the output of the following code?

```js
let arr = [1, 2, 3, 4, 5];
console.log(arr.toString());
```

## --answers--

`"[object Array]"`

### --feedback--

Arrays in JavaScript have a custom implementation of the `toString()` method.

---

`"1,2,3,4,5"`

---

`"12345"`

### --feedback--

Arrays in JavaScript have a custom implementation of the `toString()` method.

---

`Error`

### --feedback--

Arrays in JavaScript have a custom implementation of the `toString()` method.

## --video-solution--

2

## --text--

What will be the output of the following code?

```js
let obj = { name: "John", age: 30 };
console.log(obj.toString());
```

## --answers--

`"{ name: 'John', age: 30 }"`

### --feedback--

By default, the `toString()` method for objects in JavaScript returns a less readable string representation.

---

`"[object Object]"`

---

`"John30"`

### --feedback--

By default, the `toString()` method for objects in JavaScript returns a less readable string representation.

---

`Error`

### --feedback--

By default, the `toString()` method for objects in JavaScript returns a less readable string representation.

## --video-solution--

2
