---
id: 673271f39f124ddac28866d5
title: What Are Bitwise Operators, and How Do They Work?
challengeType: 19
dashedName: what-are-bitwise-operators-and-how-do-they-work
---

# --interactive--

Bitwise operators in JavaScript are special operators that work on the binary representations of numbers. To understand bitwise operators, we first need to grasp the concept of bits and binary numbers. In computing, a bit is the most basic unit of information. It can have only two values: `0` or `1`. Binary is a number system that uses only these two digits to represent all numbers.

For example, the binary representation of the decimal number `10` is `1010`. In this system, each digit represents a power of `2`, starting from the rightmost digit and increasing as we move left.

<table>
  <tr>
    <td>1</td>
    <td>0</td>
    <td>1</td>
    <td>0</td>
  </tr>
  <tr>
    <td role="math" aria-label="1 times 2 to the power of 3">1 · 2<sup>3</sup></td>
    <td role="math" aria-label="0 times 2 to the power of 2">0 · 2<sup>2</sup></td>
    <td role="math" aria-label="1 times 2 to the power of 1">1 · 2<sup>1</sup></td>
    <td role="math" aria-label="0 times 2 to the power of 0">0 · 2<sup>0</sup></td>
  </tr>
  <tr>
    <td>8</td>
    <td>0</td>
    <td>2</td>
    <td>0</td>
  </tr>
<table>

In the table above, the first row shows the binary number `1010`, the second row shows the power of `2` represented by each binary position, and the third row shows the result of each multiplication. If you add all the values in the third row, they total `10`.

Now, let's dive into bitwise operators. These operators perform operations on the binary representations of numbers. JavaScript provides several bitwise operators, including AND (`&`), OR (`|`), XOR (`^`), NOT (`~`), left shift (`<<`), and right shift (`>>`).

The bitwise AND (`&`) operator returns a `1` in each bit position for which the corresponding bits of both operands are `1`. Here's an example:

:::interactive_editor

```js
let a = 5;  // Binary: 101
let b = 3;  // Binary: 011
console.log(a & b);  // 1 (Binary: 001)
```

:::

In this example, we perform a bitwise AND operation on `5` (`101` in binary) and `3` (`011` in binary). The result is `1` (`001` in binary) because only the rightmost bit is `1` in both numbers.

The bitwise OR (`|`) operator returns a `1` in each bit position for which the corresponding bits of either or both operands are `1`. For example:

:::interactive_editor

```js
let a = 5;  // Binary: 101
let b = 3;  // Binary: 011
console.log(a | b);  // 7 (Binary: 111)
```

:::

Here, the result is `7` (`111` in binary) because at least one of the bits is `1` in each position.

The bitwise XOR (`^`) operator returns a `1` in each bit position for which the corresponding bits of either, but not both, operands are `1`. For instance:

:::interactive_editor

```js
let a = 5;  // Binary: 101
let b = 3;  // Binary: 011
console.log(a ^ b);  // 6 (Binary: 110)
```

:::

The result is `6` (`110` in binary) because the first and second bits from the right are different in the two numbers.

The bitwise NOT (`~`) operator inverts all the bits of its operand. For example:

:::interactive_editor

```js
let a = 5;  // Binary: 101
console.log(~a);  // -6
```

:::

This might seem surprising, but it's because of how negative numbers are represented in binary using two's complement.

The left shift (`<<`) operator shifts all bits to the left by a specified number of positions. For example:

:::interactive_editor

```js
let a = 5;  // Binary: 101
console.log(a << 1);  // 10 (Binary: 1010)
```

:::

Here, all bits are shifted one position to the left, effectively multiplying the number by `2`.

The right shift (`>>`) operator shifts all bits to the right. For example:

:::interactive_editor

```js
let a = 5;  // Binary: 101
console.log(a >> 1);  // 2 (Binary: 10)
```

:::

Here, all bits are shifted one position to the right, effectively dividing the number by `2` and rounding down.

Bitwise operators are often used in low-level programming and cryptography. While they may not be as commonly used in everyday JavaScript programming, understanding them can be beneficial for certain specialized tasks and can deepen your understanding of how computers work at a fundamental level.

# --questions--

## --text--

What will be the output of the following code?

```js
let a = 5;  // Binary: 101
let b = 3;  // Binary: 011
console.log(a & b);
```

## --answers--

`8`

### --feedback--

The bitwise `AND` operator returns `1` only where both operands have `1` in their binary representation.

---

`1`

---

`7`

### --feedback--

The bitwise `AND` operator returns `1` only where both operands have `1` in their binary representation.

---

`15`

### --feedback--

The bitwise `AND` operator returns `1` only where both operands have `1` in their binary representation.

## --video-solution--

2

## --text--

What will be the result of the following operation?

```js
let x = 8;  // Binary: 1000
console.log(x << 2);
```

## --answers--

`4`

### --feedback--

The left shift operator moves all bits to the left by the specified number of positions.

---

`16`

### --feedback--

The left shift operator moves all bits to the left by the specified number of positions.

---

`32`

---

`2`

### --feedback--

The left shift operator moves all bits to the left by the specified number of positions.

## --video-solution--

3

## --text--

What is the binary representation of the number `6`?

## --answers--

`101`

### --feedback--

Remember that in binary, each digit represents a power of 2, starting from the rightmost digit.

---

`110`

---

`111`

### --feedback--

Remember that in binary, each digit represents a power of 2, starting from the rightmost digit.

---

`100`

### --feedback--

Remember that in binary, each digit represents a power of 2, starting from the rightmost digit.

## --video-solution--

2
