---
id: 587d7fb6367417b2b2512c09
title: Create and Save a Record of a Model
challengeType: 2
forumTopicId: 301536
dashedName: create-and-save-a-record-of-a-model
---

# --description--

In this challenge you will have to create and save a record of a model.

# --instructions--

Within the `createAndSavePerson` function, create a document instance using the `Person` model constructor you built before. Pass to the constructor an object having the fields `name`, `age`, and `favoriteFoods`. Their types must conform to the ones in the `personSchema`. Then, call the method `document.save()` on the returned document instance. Pass to it a callback using the Node convention. This is a common pattern; all the following CRUD methods take a callback function like this as the last argument.

```js
/* Example */

// ...
person.save(function(err, data) {
  //   ...do your stuff here...
});
```

# --hints--

Creating and saving a db item should succeed

```js
  const response = await fetch(code + '/_api/create-and-save-person');
  if (!response.ok) {
    throw new Error(await response.text());
  }
  const data = await response.json();
  assert.isString(data.name, '"item.name" should be a String');
  assert.isNumber(data.age, '28', '"item.age" should be a Number');
  assert.isArray(
    data.favoriteFoods,
    '"item.favoriteFoods" should be an Array'
  );
  assert.equal(data.__v, 0, 'The db item should be not previously edited');
```

