---
id: 587d7fb7367417b2b2512c0a
title: Create Many Records with model.create()
challengeType: 2
forumTopicId: 301537
dashedName: create-many-records-with-model-create
---

# --description--

Sometimes you need to create many instances of your models, e.g. when seeding a database with initial data. `Model.create()` takes an array of objects like `[{name: 'John', ...}, {...}, ...]` as the first argument, and saves them all in the db.

# --instructions--

Modify the `createManyPeople` function to create many people using `Model.create()` with the argument `arrayOfPeople`.

**Note:** You can reuse the model you instantiated in the previous exercise.

# --hints--

Creating many db items at once should succeed

```js
  const response = await fetch(code + '/_api/create-many-people', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json'
    },
    body: JSON.stringify([
      { name: 'John', age: 24, favoriteFoods: ['pizza', 'salad'] },
      { name: 'Mary', age: 21, favoriteFoods: ['onions', 'chicken'] }
    ])
  });
  if (!response.ok) {
    throw new Error(await response.text());
  }
  const data = await response.json();
  assert.isArray(data, 'the response should be an array');
  assert.equal(
    data.length,
    2,
    'the response does not contain the expected number of items'
  );
  assert.equal(data[0].name, 'John', 'The first item is not correct');
  assert.equal(
    data[0].__v,
    0,
    'The first item should be not previously edited'
  );
  assert.equal(data[1].name, 'Mary', 'The second item is not correct');
  assert.equal(
    data[1].__v,
    0,
    'The second item should be not previously edited'
  );
```

