---
id: 587d824a367417b2b2512c46
title: Learn How JavaScript Assertions Work
challengeType: 2
forumTopicId: 301589
dashedName: learn-how-javascript-assertions-work
---

# --description--

Working on these challenges will involve you writing your code using one of the following methods:

- Clone <a href="https://github.com/freeCodeCamp/boilerplate-mochachai/" target="_blank" rel="noopener noreferrer nofollow">this GitHub repo</a> and complete these challenges locally.
- Use a site builder of your choice to complete the project. Be sure to incorporate all the files from our GitHub repo.

# --instructions--

Within `tests/1_unit-tests.js` under the test labeled `#1` in the `Basic Assertions` suite, change each `assert` to either `assert.isNull` or `assert.isNotNull` to make the test pass (should evaluate to `true`). Do not alter the arguments passed to the asserts.

# --hints--

All tests should pass.

```js
  const response = await fetch(code + '/_api/get-tests?type=unit&n=0');
  if (!response.ok) {
    throw new Error(await response.text());
  }
  const data = await response.json();
  assert.equal(data.state, 'passed');
```

You should choose the correct method for the first assertion - `isNull` vs. `isNotNull`.

```js
  const response = await fetch(code + '/_api/get-tests?type=unit&n=0');
  if (!response.ok) {
    throw new Error(await response.text());
  }
  const data = await response.json();
  assert.equal(data.assertions[0].method, 'isNull', 'Null is null');
```

You should choose the correct method for the second assertion - `isNull` vs. `isNotNull`.

```js
  const response = await fetch(code + '/_api/get-tests?type=unit&n=0');
  if (!response.ok) {
    throw new Error(await response.text());
  }
  const data = await response.json();
  assert.equal(data.assertions[1].method, 'isNotNull', '1 is not null');
```

