---
id: 587d824d367417b2b2512c54
title: Use Regular Expressions to Test a String
challengeType: 2
forumTopicId: 301608
dashedName: use-regular-expressions-to-test-a-string
---

# --description--

As a reminder, this project is being built upon the following starter project cloned from <a href="https://github.com/freeCodeCamp/boilerplate-mochachai/" target="_blank" rel="noopener noreferrer nofollow">GitHub</a>.

`match()` asserts that the actual value matches the second argument regular expression.

# --instructions--

Within `tests/1_unit-tests.js` under the test labeled `#15` in the `Strings` suite, change each `assert` to either `assert.match` or `assert.notMatch` to make the test pass (should evaluate to `true`). Do not alter the arguments passed to the asserts.

# --hints--

All tests should pass.

```js
const response = await fetch(code + '/_api/get-tests?type=unit&n=14');
if (!response.ok) {
  throw Error(await response.text());
}
const data = await response.json();
assert.equal(data.state, 'passed');
```

You should choose the correct method for the first assertion - `match` vs. `notMatch`.

```js
const response = await fetch(code + '/_api/get-tests?type=unit&n=14');
if (!response.ok) {
  throw Error(await response.text());
}
const data = await response.json();
assert.equal(
  data.assertions[0].method,
  'match',
  "'# name:John Doe, age:35' matches the regex"
);
```

You should choose the correct method for the second assertion - `match` vs. `notMatch`.

```js
const response = await fetch(code + '/_api/get-tests?type=unit&n=14');
if (!response.ok) {
  throw Error(await response.text());
}
const data = await response.json();
assert.equal(
  data.assertions[1].method,
  'notMatch',
  "'# name:Paul Smith III, age:twenty-four' does not match the regex (the age must be numeric)"
);
```

