---
id: 587d824f367417b2b2512c59
title: Run Functional Tests on API Endpoints using Chai-HTTP II
challengeType: 2
forumTopicId: 301592
dashedName: run-functional-tests-on-api-endpoints-using-chai-http-ii
---

# --description--

As a reminder, this project is being built upon the following starter project cloned from <a href="https://github.com/freeCodeCamp/boilerplate-mochachai/" target="_blank" rel="noopener noreferrer nofollow">GitHub</a>.

# --instructions--

Within `tests/2_functional-tests.js`, alter the `'Test GET /hello with your name'` test (`// #2`) to assert the `status` and the `text` of the response to make the test pass.

Send your name as a URL query by appending `?name=<your_name>` to the route. The endpoint responds with `'hello <your_name>'`.

# --hints--

All tests should pass

```js
const response = await fetch(code + '/_api/get-tests?type=functional&n=1');
if (!response.ok) {
  throw Error(await response.text());
}
const data = await response.json();
assert.equal(data.state, 'passed');
```

You should test for `res.status` == 200

```js
const response = await fetch(code + '/_api/get-tests?type=functional&n=1');
if (!response.ok) {
  throw Error(await response.text());
}
const data = await response.json();
assert.equal(data.assertions[0].method, 'equal');
assert.equal(data.assertions[0].args[0], 'res.status');
assert.equal(data.assertions[0].args[1], '200');
```

You should test for `res.text` == `'hello <your_name>'`

```js
const response = await fetch(code + '/_api/get-tests?type=functional&n=1');
if (!response.ok) {
  throw Error(await response.text());
}
const data = await response.json();
assert.equal(data.assertions[1].method, 'equal');
assert.equal(data.assertions[1].args[0], 'res.text');
assert.match(data.assertions[1].args[1], /hello [\w\d_-]/);
```

