---
id: 66f1afbd9998e9c985d8e73b
title: Bash Scripting Quiz
challengeType: 8
dashedName: quiz-bash-scripting
---

# --description--

To pass the quiz, you must correctly answer at least 18 of the 20 questions below.

# --quizzes--

## --quiz--

### --question--

#### --text--

What is a correct shebang line in bash script?

#### --distractors--

`!#/bin/bash`

---

`/#!bin/bash`

---

`/#!/bin/bash`

#### --answer--

`#!/bin/bash`

### --question--

#### --text--

Which command would define `MY_VAR` and print it to the console?

#### --distractors--

`MY_VAR=10; echo MY_VAR`

---

`$MY_VAR=10; echo MY_VAR`

---

`$MY_VAR=10; echo $MY_VAR`

#### --answer--

`MY_VAR=10; echo $MY_VAR`

### --question--

#### --text--

Which command is used to view all variables in the shell?

#### --distractors--

`declare -n env`

---

`declare -p env`

---

`declare -x bashrc`

#### --answer--

`declare -p`

### --question--

#### --text--

Which command would run a `script.sh` file?

#### --distractors--

`script.sh bash`

---

`zsh ./script.sh`

---

`./sh script.sh`

#### --answer--

`./script.sh`

### --question--

#### --text--

How to view the manual for the `less` command in bash?

#### --distractors--

`less man`

---

`less --man`

---

`man --less`

#### --answer--

`man less`

### --question--

#### --text--

How would you call the `print_arguments` function to print `a` and `b` to the terminal?

```bash
print_arguments() {
  echo "Argument 1: $1"
  echo "Argument 2: $2"
}

```

#### --distractors--

`print_arguments("a", "b")`

---

`print_arguments(a, b)`

---

`print_arguments{a, b}`

#### --answer--

`print_arguments "a" "b"`

### --question--

#### --text--

How do you initialize an array in bash?

#### --distractors--

`ARR=["item1" "item2" "item3"]`

---

`ARR=[["item1" "item2" "item3"]]`

---

`ARR={"item1" "item2" "item3"}`

#### --answer--

`ARR=("item1" "item2" "item3")`

### --question--

#### --text--

How do you print the third value of an array in bash?

#### --distractors--

`echo ${ARR[3]}`

---

`echo $ARR[2]`

---

`echo $ARR[3]`

#### --answer--

`echo ${ARR[2]}`

### --question--

#### --text--

How do you assign user input to a variable in bash?

#### --distractors--

`input MY_VAR`

---

`cin MY_VAR`

---

`get MY_VAR`

#### --answer--

`read MY_VAR`

### --question--

#### --text--

What will be the permission flags for the `1.txt` file after executing the command `chmod 765 1.txt`?

#### --distractors--

`rwxrwxrwx`

---

`rwxr-xrw-`

---

`r-xrw-rwx`

#### --answer--

`rwxrw-r-x`

### --question--

#### --text--

What keyword does the statement `if ... then ...` end with?

#### --distractors--

`end`

---

`done`

---

`stop`

#### --answer--

`fi`

### --question--

#### --text--

What keyword does the statement `for ... do ...` end with?

#### --distractors--

`end`

---

`od`

---

`stop`

#### --answer--

`done`

### --question--

#### --text--

How do you create a comment in bash?

#### --distractors--

`// comment`

---

`!comment`

---

`/* comment`

#### --answer--

`# comment`

### --question--

#### --text--

What line should you add to the beginning of this snippet to create a `for` loop?

```bash

do
    echo $i
done
```

#### --distractors--

`for ( int i = 0; i < 10; i++ )`

---

`for (( int i = 0; i < 10; i++ ))`

---

`for (( let i = 0; i < 10; i++ ))`

#### --answer--

`for (( i = 0; i < 10; i++ ))`

### --question--

#### --text--

How would you assign the result of the sum of variables `A` and `B` to the variable `C`?

#### --distractors--

`C=$A + $B`

---

`C=$( A + B )`

---

`$C=$(( $A + $B ))`

#### --answer--

`C=$(( A + B ))`

### --question--

#### --text--

Which command is used to create a new file?

#### --distractors--

`newfile`

---

`echo new_file`

---

`fileargs`

#### --answer--

`touch`

### --question--

#### --text--

What does the command `echo $?` do?

#### --distractors--

Prints the value of the last used variable.

---

Prints the value of the last used arithmetic operation.

---

Prints the value of the last executed condition.

#### --answer--

Prints the exit code of the last executed command.

### --question--

#### --text--

What advantage does Bash provide when testing parts of a script?

#### --distractors--

Bash scripts must be compiled before testing

---

You can only test scripts using an IDE

---

Bash automatically generates test cases

#### --answer--

Script sections can be pasted directly into the terminal for testing

### --question--

#### --text--

What types of loops exist in bash?

#### --distractors--

`for`

---

`for`, `while`

---

`for`, `while`, `until`, `forEach`

#### --answer--

`for`, `while`, `until`

### --question--

#### --text--

How do you print all values of an array in bash?

#### --distractors--

`echo $ARR[@]`

---

`echo {ARR[@]}`

---

`echo ${ARR[$@]}`

#### --answer--

`echo ${ARR[@]}`

