---
id: 66ed8ff4f45ce3ece4053eb4
title: CSS Layout and Effects Quiz
challengeType: 8
dashedName: quiz-css-layout-and-effects
---

# --description--

To pass the quiz, you must correctly answer at least 18 of the 20 questions below.

# --quizzes--

## --quiz--

### --question--

#### --text--

What term is used in CSS to describe when an element's content exceeds the size of its container?

#### --distractors--

Underflow

---

Compression

---

Padding

#### --answer--

Overflow

### --question--

#### --text--

What is the default behavior of CSS when content overflows an element?

#### --distractors--

Hiding the content.

---

Clipping the content.

---

Resizing the content.

#### --answer--

Keeping the content visible.

### --question--

#### --text--

Why does CSS typically avoid hiding content when there is overflow?

#### --distractors--

To maintain the original layout and design.

---

To prevent performance issues in the browser.

---

To allow for better search engine optimization.

#### --answer--

To ensure all content is accessible to users.

### --question--

#### --text--

How can you handle vertical overflow in CSS by hiding content or displaying scrollbars?

#### --distractors--

Use `overflow-y: visible` to hide content and `overflow-y: auto` to always display scrollbars.

---

Use `overflow-y: collapse` to hide content and `overflow-y: expand` to display scrollbars.

---

Use `overflow-y: none` to hide content and `overflow-y: show` to display scrollbars.

#### --answer--

Use `overflow-y: hidden` to hide content and `overflow-y: scroll` to always display scrollbars.

### --question--

#### --text--

How can you specify different horizontal and vertical scrolling behaviors in CSS?

#### --distractors--

By using the `scroll-x` and `scroll-y` properties.

---

By specifying the same value for `overflow-x` and `overflow-y`.

---

By specifying two values for the `overflow` property, where the first value applies to `overflow-y` and the second value to `overflow-x`.

#### --answer--

By specifying two values for the `overflow` property, where the first value applies to `overflow-x` and the second value to `overflow-y`.

### --question--

#### --text--

What does the `transform` CSS property allow you to do?

#### --distractors--

Change the color and font style of an element.

---

Adjust the margin and padding of an element.

---

Modify the visibility and display of an element.

#### --answer--

Rotate, scale, skew, and translate an element.

### --question--

#### --text--

How does the `transform: translate(15px, 200px)` property modify an element?

#### --distractors--

It moves the element 15 pixels to the left and 200 pixels down from its original position.

---

It rotates the element 15 degrees in a clockwise direction.

---

It moves the element 15 pixels to the right and 200 pixels up from its original position.

#### --answer--

It moves the element 15 pixels to the right and 200 pixels down from its original position.

### --question--

#### --text--

What is the purpose of the CSS properties `overflow-x` and `overflow-y`?

#### --distractors--

They adjust the padding and margin of an element.

---

They set the background color and font style of an element.

---

They define the visibility and display properties of an element.

#### --answer--

They control the horizontal and vertical overflow of an element's content.

### --question--

#### --text--

What is the purpose of the `margin` property in CSS?

#### --distractors--

It defines the space between the content and the border of an element.

---

It defines the space between the border and the padding of an element.

---

It defines the width and height of an element.

#### --answer--

It defines the space around an element, outside of its border.

### --question--

#### --text--

What does the content area of an element represent in CSS?

#### --distractors--

It defines the margins and padding around the element.

---

It defines the thickness of the element's border.

---

It controls the visibility of the element on the page.

#### --answer--

It contains the actual content of the element, such as text, images, and videos.

### --question--

#### --text--

What is the difference between `content-box` and `border-box` in CSS?

#### --distractors--

`content-box` includes padding and border, while `border-box` includes only content dimensions.

---

Both `content-box` and `border-box` include only the border dimensions.

---

`content-box` is used for 2D elements, while `border-box` is used for 3D elements.

#### --answer--

`content-box` includes only content dimensions, while `border-box` includes content, padding, and border in the dimensions.

### --question--

#### --text--

What is the purpose of CSS resets?

#### --distractors--

To apply default styles to all elements for faster loading.

---

To minimize the size of CSS files by removing unused styles.

---

To optimize images and fonts for better performance.

#### --answer--

To remove default browser styling and ensure consistent styling across browsers.

### --question--

#### --text--

Which of the following is a common example of a CSS reset?

#### --distractors--

bootstrap.css

---

undo.css

---

restore.css

#### --answer--

normalize.css

### --question--

#### --text--

Which CSS property is used to apply changes such as rotation, scaling, and translation to elements?

#### --distractors--

`box-shadow`

---

`opacity`

---

`z-index`

#### --answer--

`transform`

### --question--

#### --text--

How is the total width of an element calculated in CSS when using the `border-box` value for the `box-sizing` property?

#### --distractors--

Total Width = Content Width + Border + Margin

---

Total Width = Content Width + Padding + Border + Margin

---

Total Width = Content Width

#### --answer--

Total Width = Content Width + Padding + Border

### --question--

#### --text--

What is the purpose of the `filter` property in CSS?

#### --distractors--

Changing the scale and rotation of an element.

---

Changing the background color and texture of an element.

---

Altering the size and position of an element.

#### --answer--

Modifying the visual appearance of an element by using various graphical effects.

### --question--

#### --text--

What does the CSS property `filter: grayscale(50%);` do to an element?

#### --distractors--

It increases the brightness of the element by 50%.

---

It decreases the contrast of the element by 50%.

---

It applies a sepia effect to the element.

#### --answer--

It applies a 50% grayscale effect to the element.

### --question--

#### --text--

What is the purpose of the `contrast()` function in CSS?

#### --distractors--

It adjusts the brightness of the image, where `0%` makes it black and `100%` makes it white.

---

It adjusts the contrast of the image, where `100%` makes it grey, `0%` has no effect, and values over `100%` increase contrast.

---

It adjusts the opacity of the image, where `0%` makes it transparent and `100%` makes it opaque.

#### --answer--

It adjusts the contrast of the image, where `0%` makes it grey, `100%` has no effect, and values over `100%` increase contrast.

### --question--

#### --text--

What is the purpose of the `hue-rotate()` function in CSS?

#### --distractors--

It changes the brightness of an image.

---

It rotates an image clockwise by a certain number of degrees.

---

It adjusts the saturation and contrast of an image.

#### --answer--

It applies a color shift, where the `angle` value defines the number of degrees to rotate around the color circle.

### --question--

#### --text--

What is margin collapsing in CSS?

#### --distractors--

When the margin of an element is set to a negative number and this causes issues in the layout.

---

When the margin of an element is decreased by the padding and this changes the element's dimensions.

---

When the margin of an element is ignored by the browser, so it's not visible.

#### --answer--

When the vertical margins of adjacent elements overlap, so they are combined into a single margin.

## --quiz--

### --question--

#### --text--

Which of the following is TRUE about the `translate()` function?

#### --distractors--

It is used to scale the size of an element.

---

It is used to translate the text of an element.

---

It is used to change the shape or size of an element.

#### --answer--

It is used to move an element from its current position.

### --question--

#### --text--

Which of the following is a component of the CSS box model?

#### --distractors--

Width

---

Height

---

Size

#### --answer--

Padding

### --question--

#### --text--

When an element's `box-sizing` is set to `content-box`, which part of the box model does the `width` and `height` apply to?

#### --distractors--

Content, padding, border, and margin

---

Content and padding

---

Content, padding, and border

#### --answer--

Content

### --question--

#### --text--

When an element's `box-sizing` is set to `border-box`, which parts of the CSS box model does the `width` and `height` NOT apply to?

#### --distractors--

The content area.

---

Padding

---

Border

#### --answer--

Margin

### --question--

#### --text--

Which value for the `brightness()` function makes an element completely black?

#### --distractors--

`100%`

---

`0px`

---

`100px`

#### --answer--

`0%`

### --question--

#### --text--

What kind of values does the `hue-rotate()` function use?

#### --distractors--

Pixels

---

Radians

---

Percentages

#### --answer--

Degrees

### --question--

#### --text--

What does the CSS property `filter: contrast(0%);` do to an element?

#### --distractors--

It will make the element appear completely white.

---

It will make the element appear completely black.

---

It will have no effect on the element.

#### --answer--

It will make the element appear completely grey.

### --question--

#### --text--

What is the minimum value for the `brightness()` CSS function to brighten an element?

#### --distractors--

`100px`

---

`50px`

---

`50%`

#### --answer--

`100%`

### --question--

#### --text--

What kind of values does the `grayscale()` function use?

#### --distractors--

Pixels

---

Degrees

---

Radians

#### --answer--

Percentages

### --question--

#### --text--

What kind of values does the `contrast()` function use?

#### --distractors--

Pixels

---

Degrees

---

Radians

#### --answer--

Percentages

### --question--

#### --text--

What does the `overflow-x` property in CSS control?

#### --distractors--

It determines the horizontal overflow on the y-axis.

---

It determines the vertical overflow on the y-axis.

---

It determines the vertical overflow on the x-axis.

#### --answer--

It determines the horizontal overflow on the x-axis.

### --question--

#### --text--

What does the `overflow-y` property in CSS control?

#### --distractors--

It determines the horizontal overflow on the x-axis.

---

It determines the vertical overflow on the x-axis.

---

It determines the horizontal overflow on the y-axis.

#### --answer--

It determines the vertical overflow on the y-axis.

### --question--

#### --text--

What is an example of a third party option for a CSS reset?

#### --distractors--

clean.css

---

restore.css

---

reset.css

#### --answer--

sanitize.css

### --question--

#### --text--

How many dimensions are there to the overflow property in CSS?

#### --distractors--

One

---

Three

---

Four

#### --answer--

Two

### --question--

#### --text--

If the shorthand property `overflow` is given two values, which property will use the first value?

#### --distractors--

`overflow-y`

---

`overflow-w`

---

`overflow-z`

#### --answer--

`overflow-x`

### --question--

#### --text--

What kind of blur effect does the `blur()` function apply to an element in CSS?

#### --distractors--

Giliani

---

Galilei

---

Galileo

#### --answer--

Gaussian

### --question--

#### --text--

What kind of values does the `sepia()` function use?

#### --distractors--

Pixels

---

Radians

---

Degrees

#### --answer--

Percentages

### --question--

#### --text--

If the shorthand property `overflow` is given two values, which property will use the second value?

#### --distractors--

`overflow-w`

---

`overflow-x`

---

`overflow-z`

#### --answer--

`overflow-y`

### --question--

#### --text--

What does a CSS reset do?

#### --distractors--

It forces browsers to use dark mode by default.

---

It removes inline styles from HTML elements.

---

It disables browser extensions that include CSS.

#### --answer--

It removes default browser styling.

### --question--

#### --text--

What does the CSS property `filter: grayscale(100%);` do to an element?

#### --distractors--

It will have no effect on the element.

---

It will make the element appear completely black.

---

It will make the element appear completely white.

#### --answer--

It removes color saturation while maintaining the element's tonal structure.

