---
id: 66ed9010f45ce3ece4053eb8
title: CSS Typography Quiz
challengeType: 8
dashedName: quiz-css-typography
---

# --description--

To pass the quiz, you must correctly answer at least 18 of the 20 questions below.

# --quizzes--

## --quiz--

### --question--

#### --text--

Which of the following is the correct way to write an `@font-face` rule in CSS?

#### --distractors--

`@font-face { font: 'MyFont'; size: 12px; }`

---

`@font-family { url: 'myfont.ttf'; }`

---

`font-face: 'MyFont', sans-serif;`

#### --answer--

`@font-face { font-family: 'MyFont'; src: url('myfont.woff2'); }`

### --question--

#### --text--

How do the offset values in the CSS `text-shadow` property affect the shadow's appearance?

#### --distractors--

They adjust the weight and color of the shadow.

---

They change the color of the shadow.

---

They remove the text from the path of the shadow.

#### --answer--

They control the position of the shadow relative to the text.

### --question--

#### --text--

What does kerning refer to in the context of typography?

#### --distractors--

How the space between lines of text is adjusted to improve readability and aesthetics.

---

How the overall spacing of a text block is adjusted for visual purposes.

---

How the font size is adjusted for accessibility purposes.

#### --answer--

How the space between specific pairs of characters is adjusted to improve readability and aesthetics.

### --question--

#### --text--

What is a font family in the context of typography?

#### --distractors--

A specific font style used for headings and body text.

---

A collection of text options for formatting text.

---

A set of visually consistent colors used for text.

#### --answer--

A group of fonts that share similar design characteristics.

### --question--

#### --text--

How do you import the `Roboto` font from Google Fonts into your CSS using the `@import` rule?

#### --distractors--

`@font-face { font-family: 'Roboto'; url: 'https://fonts.googleapis.com/css2?family=Roboto&display=swap'; }`

---

`link: 'https://fonts.googleapis.com/css2?family=Roboto';`

---

`@import google-font('Roboto');`

#### --answer--

`@import url('https://fonts.googleapis.com/css2?family=Roboto&display=swap');`

### --question--

#### --text--

Which one of the following is a web safe font?

#### --distractors--

Comic Sans MS

---

Papyrus

---

Impact

#### --answer--

Times New Roman

### --question--

#### --text--

What is the purpose of the `@font-face` rule in CSS?

#### --distractors--

It defines the font size.

---

It creates a fallback font for web pages.

---

It adjusts the line height for text.

#### --answer--

It allows you to use custom fonts by importing them.

### --question--

#### --text--

What is the baseline in the context of typography?

#### --distractors--

The parts of lowercase letters that extend above the `x-height`.

---

The average height of lowercase letters, excluding ascenders and descenders.

---

The height of uppercase letters, measured from the baseline to the top.

#### --answer--

The imaginary line on which most characters rest.

### --question--

#### --text--

Why is it important to include multiple font options in the `font-family` property?

#### --distractors--

It reduces page load time by optimizing the process of loading fonts.

---

It prevents browser compatibility issues by providing multiple options.

---

It makes the web page more engaging and interactive.

#### --answer--

It ensures a consistent user experience in case the custom font doesn't load.

### --question--

#### --text--

What is the purpose of the `text-shadow` property in CSS?

#### --distractors--

It changes the color and font family of the text.

---

It adds a decorative border and background color to the text.

---

It makes the text bold and adjusts the space between the characters.

#### --answer--

It creates a visual effect by adding a blurred or offset duplicate of the text.

### --question--

#### --text--

What is leading in the context of Typography?

#### --distractors--

A group of fonts that share a common design.

---

How space is adjusted between specific pairs of characters in a block of text.

---

How space is adjusted between all characters in a block of text.

#### --answer--

The vertical space between lines of text.

### --question--

#### --text--

Why is typographic hierarchy important in design?

#### --distractors--

It improves the readability of large blocks of text.

---

It ensures consistency across different devices.

---

It ensures that all text elements are the same size.

#### --answer--

It helps organize content and guide users through the information.

### --question--

#### --text--

Which of the following is NOT a CSS property related to fonts?

#### --distractors--

`font-size`

---

`font-weight`

---

`font-family`

#### --answer--

`font-padding`

### --question--

#### --text--

Which of the following is a correct example of the `text-shadow` property in CSS?

#### --distractors--

`text-shadow: solid 5px black;`

---

`text-shadow: 5px blur black;`

---

`text-shadow: inset 2px 2px white;`

#### --answer--

`text-shadow: 2px 2px 5px rgba(0, 0, 0, 0.5);`

### --question--

#### --text--

What are web safe fonts?

#### --distractors--

Fonts that provide advanced typographic features.

---

Fonts that automatically adjust to the user's preferred settings.

---

Fonts that are specifically designed for print media.

#### --answer--

Fonts that are very likely to be available on most devices and browsers.

### --question--

#### --text--

Why are sans-serif fonts generally considered easier to read on screens than serif fonts?

#### --distractors--

Because they have small lines at the end of characters.

---

Because they are primarily used for decorative purposes.

---

Because they were specifically designed for print media.

#### --answer--

Because they have simple and clean lines.

### --question--

#### --text--

How do you specify multiple font families in the `font-family` property in CSS?

#### --distractors--

By separating them with spaces and listing the preferred font last.

---

By separating them with commas and listing the preferred font last.

---

By enclosing them in curly braces and listing the preferred font first.

#### --answer--

By separating them with commas and listing the preferred font first.

### --question--

#### --text--

In the `@font-face` rule, which property specifies where the font file is located?

#### --distractors--

`font-size`

---

`url`

---

`font-family`

#### --answer--

`src`

### --question--

#### --text--

Which of the following is a good practice when using fonts in web design?

#### --distractors--

Always using at least eight different font families throughout the website.

---

Using decorative fonts for both headings and body text.

---

Avoiding fallback fonts whenever possible.

#### --answer--

Using no more than two or three font families to ensure visual consistency.

### --question--

#### --text--

What is tracking in the context of typography?

#### --distractors--

The parts of lowercase letters that extend below the baseline.

---

The average height of lowercase letters, excluding ascenders and descenders.

---

How space is adjusted between all lines of text in a block of text.

#### --answer--

How space is adjusted between all characters in a block of text.

## --quiz--

### --question--

#### --text--

What is typography?

#### --distractors--

It is the overall design and style of a set of characters, numbers, and symbols.

---

It is about how the individual characters are designed and arranged on a page.

---

It is the specific variation of a typeface with specific characteristics.

#### --answer--

It is the art of choosing fonts and format to make text visually appealing and easy to read.

### --question--

#### --text--

What characteristics does the font weight NOT include?

#### --distractors--

Light

---

Regular

---

Bold

#### --answer--

Italics

### --question--

#### --text--

Which lowercase letter does NOT contain an ascender?

#### --distractors--

`h`

---

`b`

---

`f`

#### --answer--

`g`

### --question--

#### --text--

Which lowercase letter does NOT contain a descender?

#### --distractors--

`y`

---

`g`

---

`q`

#### --answer--

`d`

### --question--

#### --text--

What does tracking affect in typography?

#### --distractors--

It affects the vertical alignment of characters.

---

It affects how complementary fonts are used.

---

It affects the slant and orientation of characters.

#### --answer--

It affects how dense and open the text will be.

### --question--

#### --text--

Where are web safe fonts stored?

#### --distractors--

In the website hosting the web page.

---

In folders on internet servers.

---

In the `styles.css` file.

#### --answer--

In the system files of the computer or device.

### --question--

#### --text--

Which of the following is NOT a valid format for a font?

#### --distractors--

`woff`

---

`collection`

---

`svg`

#### --answer--

`ett`

### --question--

#### --text--

What does the acronym `woff` stand for?

#### --distractors--

Web Only Font Format.

---

Web Open Font Family.

---

Web Only Font Family.

#### --answer--

Web Open Font Format.

### --question--

#### --text--

Which character can you use to separate multiple `text-shadow` property values?

#### --distractors--

`.`

---

`;`

---

`:`

#### --answer--

`,`

### --question--

#### --text--

How is leading measured in typography?

#### --distractors--

From the end of one character to the start of the next character.

---

From the average height of uppercase letters to average height of lowercase letters.

---

From the baseline to the top of uppercase letters.

#### --answer--

From the baseline of one line to the baseline of the next line.

### --question--

#### --text--

What is an example of kerning?

#### --distractors--

Moving the tails of lowercase letters `y` and `g` above the baseline.

---

Adjusting the space between all characters.

---

Adjusting the white space between words.

#### --answer--

Reducing the space between the letters `A` and `V`.

### --question--

#### --text--

What is an example of a serif font?

#### --distractors--

It does not have small lines at the end of characters.

---

It has small dots at the end of characters.

---

It has large dots at the end of characters.

#### --answer--

It has small lines at the end of characters.

### --question--

#### --text--

Which of the following is TRUE about a sans-serif font?

#### --distractors--

It has small dots at the end of characters.

---

It has large dots at the end of characters.

---

It has small lines at the end of characters.

#### --answer--

It does not have small lines at the end of characters.

### --question--

#### --text--

Which example correctly uses the `font-family` property?

#### --distractors--

```css
font-family {
  body: Arial;
}
```

---

```css
body {
  Arial: font-family;
}
```

---

```css
body {
  font-family; Arial:
}
```


#### --answer--

```css
body {
  font-family: Arial;
}
```


### --question--

#### --text--

What is font weight in typography?

#### --distractors--

It is the weight of the font.

---

It is the size of the font.

---

It is the average weight of the characters.

#### --answer--

It is the thickness of the characters.

### --question--

#### --text--

What is a best practice with typography?

#### --distractors--

Choosing commonly used fonts as they can load in a short amount of time.

---

Using metrics to see how many users visit your site and engage with the content.

---

Using unique fonts and images that are eye catching and relevant to the content.

#### --answer--

Choosing clear and simple fonts to make your designs easy to understand.

### --question--

#### --text--

How are font families related?

#### --distractors--

They are developed by the same design team.

---

They are all designed by the same designer.

---

They share the same name but are based on a different typeface.

#### --answer--

They are a group of fonts that share a common design.

### --question--

#### --text--

Which element is used when accessing external fonts?

#### --distractors--

`style`

---

`meta`

---

`head`

#### --answer--

`link`

### --question--

#### --text--

Which of the following can be used to access external fonts?

#### --distractors--

`style`

---

`@font-face`

---

`meta`

#### --answer--

`@import`

### --question--

#### --text--

Which attribute does the `link` element use to access fonts?

#### --distractors--

`rel`

---

`url`

---

`src`

#### --answer--

`href`

