---
id: 66ed9018f45ce3ece4053eb9
title: CSS Variables Quiz
challengeType: 8
dashedName: quiz-css-variables
---

# --description--

To pass the quiz, you must correctly answer at least 18 of the 20 questions below.

# --quizzes--

## --quiz--

### --question--

#### --text--

Which of the following is NOT a valid descriptor in the `@property` rule?

#### --distractors--

`syntax`

---

`inherits`

---

`initial-value`

#### --answer--

`animation`

### --question--

#### --text--

In the following code, which value will `color` have if `--main-color` is not defined?

```css
p {
  color: var(--main-color, pink);
}
```

#### --distractors--

`Undefined`

---

No color will be applied.

---

`--main-color`

#### --answer--

`pink`

### --question--

#### --text--

Which of the following is a valid way to declare a custom property in CSS?

#### --distractors--

`$background-color: #333;`

---

`@property: #333`

---

`var(--background-color: #333);`

#### --answer--

`--background-color: #333;`

### --question--

#### --text--

What is the main purpose of using custom properties in CSS?

#### --distractors--

To change the DOM structure.

---

To create dynamic selectors.

---

To improve accessibility.

#### --answer--

To define reusable styles.

### --question--

#### --text--

What does the `:root` selector represent?

#### --distractors--

The first child element of the `body`.

---

The parent element of all `header` elements.

---

The first child of the `html` tag.

#### --answer--

The highest-level element in the DOM tree.

### --question--

#### --text--

How do you apply a `--foreground` custom property as the `color` in CSS?

#### --distractors--

`color: --foreground;`

---

`color: css(--foreground);`

---

`color: $foreground;`

#### --answer--

`color: var(--foreground);`

### --question--

#### --text--

What is the purpose of the `@property` rule in CSS?

#### --distractors--

To define a media query.

---

To control CSS animations and their timing.

---

To group CSS properties into one rule.

#### --answer--

To define how custom properties behave.

### --question--

#### --text--

When declaring a custom `@property`, what is the purpose of the `syntax` in its definition?

#### --distractors--

It specifies the default value of the custom property.

---

It determines whether the property can be inherited by child elements.

---

It defines whether the property is applied to all elements.

#### --answer--

It enforces a specific data type or value pattern for the custom property.

### --question--

#### --text--

What should you be cautious of when using custom properties?

#### --distractors--

Custom properties are automatically converted to `px` units.

---

Custom properties always override inline styles.

---

Custom properties cannot be used to set font values.

#### --answer--

Custom properties may not be supported in older browsers.

### --question--

#### --text--

What is the purpose of providing a fallback value in the `var()` function for CSS custom properties?

#### --distractors--

To reduce the amount of CSS code.

---

To improve performance in modern browsers.

---

To optimize rendering time on slow networks.

#### --answer--

To ensure a valid value is applied if the custom property is undefined.

### --question--

#### --text--

When defining a variable `--foreground` inside a media query, what happens when the media query no longer matches the current viewport?

#### --distractors--

The custom property is preserved and continues to apply.

---

The custom property reverts to its initial value.

---

The custom property is recalculated based on the viewport.

#### --answer--

The custom property is no longer available as it is scoped to the media query.

### --question--

#### --text--

How would the following declaration behave?

```css
color: var(--main-color, var(--fallback-color, #000));
```

#### --distractors--

It will apply `--main-color` even if it is not defined, defaulting to that value.

---

It will apply `--main-color` and `--fallback-color` simultaneously, resulting in a blend of the two colors.

---

It will always default to `#000`, regardless of whether `--main-color` or `--fallback-color` is defined.

#### --answer--

It applies `--main-color` if defined; otherwise, checks `--fallback-color;` and if both are undefined, it uses `#000`.

### --question--

#### --text--

What is one benefit of using `@property` in CSS?

#### --distractors--

It improves performance by precomputing custom property values.

---

It automatically prefixes custom properties for better browser support.

---

It restricts the use of custom properties to specific elements.

#### --answer--

It allows for animations of custom properties.

### --question--

#### --text--

What does the `inherits` property in a custom `@property` declaration control?

#### --distractors--

Whether the custom property will have an initial value.

---

Whether the property can have a shorthand version.

---

Whether the property accepts fallback values.

#### --answer--

Whether the custom property's value is passed to child elements.

### --question--

#### --text--

In the declaration of a custom `@property`, what does the `initial-value` specify?

#### --distractors--

The acceptable values the property can accept.

---

The priority of the property in the cascade.

---

The type of value the property must have.

#### --answer--

The fallback value for the property.

### --question--

#### --text--

Given the following HTML and CSS code, what will be the value of the `color` property for the `.box` element?

```html
<div class="container">
  <div class="box">Text</div>
</div>
```

```css
:root {
  --main-color: red;
}

.container {
  --main-color: blue;
}

.box {
  color: var(--main-color, black);
}
```

#### --distractors--

`black`

---

`red`

---

`green`

#### --answer--

`blue`

### --question--

#### --text--

Which property should a CSS gradient be applied to?

#### --distractors--

`color`

---

`border-radius`

---

`box-shadow`

#### --answer--

`background`

### --question--

#### --text--

What is the purpose of color stops in CSS gradients?

#### --distractors--

To define the transparency level of the gradient.

---

To specify the direction of the gradient.

---

To repeat the gradient in a fixed pattern.

#### --answer--

To define the specific points where colors change in the gradient.

### --question--

#### --text--

What happens if no angle or direction is specified in a CSS linear gradient?

#### --distractors--

The gradient defaults to a diagonal direction.

---

The gradient defaults to moving from bottom to top.

---

The gradient defaults to moving from left to right.

#### --answer--

The gradient defaults to moving from top to bottom.

### --question--

#### --text--

Which CSS gradient function allows you to create a gradient that radiates outward from a central point?

#### --distractors--

`linear-gradient()`

---

`conic-gradient()`

---

`repeating-linear-gradient()`

#### --answer--

`radial-gradient()`

## --quiz--

### --question--

#### --text--

Which of the following is a correct way to declare a CSS custom property?

#### --distractors--

`background-color: var(--blue);`

---

`custom-property: blue;`

---

`define --my-color: blue;`

#### --answer--

`--my-color: blue;`

### --question--

#### --text--

What selector is typically used to define global CSS custom properties?

#### --distractors--

`.global {}`

---

`* {}`

---

`body {}`

#### --answer--

`:root {}`

### --question--

#### --text--

When using `var()`, why is it recommended to include a fallback value?

#### --distractors--

It ensures the variable will animate correctly.

---

It avoids loading external stylesheets.

---

It prevents browser reflow.

#### --answer--

It guarantees a valid value if the custom property is undefined.

### --question--

#### --text--

What is the correct syntax to apply a custom property as a background color?

#### --distractors--

`background: get(--main-bg);`

---

`background: css(--main-bg);`

---

`background: --main-bg;`

#### --answer--

`background: var(--main-bg);`

### --question--

#### --text--

Which CSS rule allows developers to define custom properties with greater control over their behavior?

#### --distractors--

`@media`

---

`@keyframes`

---

`@supports`

#### --answer--

`@property`

### --question--

#### --text--

What does the `inherits` field in an `@property` definition control?

#### --distractors--

Whether the property is used in JavaScript.

---

Whether the property will trigger repaints.

---

Whether the property can contain functions.

#### --answer--

Whether the property's value is passed to child elements.

### --question--

#### --text--

When defining an animated gradient angle using `@property`, which syntax should be used?

#### --distractors--

`"<number>"`

---

`"<color>"`

---

`"<string>"`

#### --answer--

`"<angle>"`

### --question--

#### --text--

What distinguishes a CSS custom property from a standard CSS property in terms of how it's defined?

#### --distractors--

Standard CSS properties are defined with a single dash, while custom properties use two dashes.

---

Standard CSS properties use `var()` for definition, while custom properties do not.

---

Standard CSS properties are defined using the `@property` rule, while custom properties are not.

#### --answer--

Custom properties must start with two dashes (`--`), while standard CSS properties do not.

### --question--

#### --text--

Which of these is a benefit of using CSS custom properties?

#### --distractors--

They reduce the need for CSS comments.

---

They automatically optimize images.

---

They make JavaScript variables obsolete.

#### --answer--

They allow styles to be reused and centrally maintained.

### --question--

#### --text--

Which CSS property can change dynamically based on media queries using custom properties?

#### --distractors--

Only `background-color`

---

Only `font-family`

---

Only `z-index`

#### --answer--

Any property that accepts a value.

### --question--

#### --text--

In the context of CSS variables, what is the role of `initial-value` in an `@property` rule?

#### --distractors--

It sets the minimum value of the property.

---

It defines the maximum value for animations.

---

It changes the selector priority.

#### --answer--

It assigns a default value for the property if none is set.

### --question--

#### --text--

Consider the following HTML and CSS. What background color will be applied to the `.card` element?

```html
<div class="dark-theme">
  <div class="card">Content</div>
</div>
```

```css
:root {
  --bg-color: white;
}

.dark-theme {
  --bg-color: #333;
}

.card {
  background: var(--bg-color);
}
```

#### --distractors--

`white`

---

`transparent`

---

`inherit`

#### --answer--

`#333`

### --question--

#### --text--

In the following CSS, what happens if a user tries to assign an invalid value to `--padding` (for example, a color instead of a length)?

```css
@property --padding {
  syntax: "<length>";
  initial-value: 0px;
  inherits: false;
}
```

#### --distractors--

The browser accepts the value but ignores it during layout.

---

The browser throws a runtime error.

---

The browser converts the value to a valid length automatically.

#### --answer--

The browser falls back to the property's initial value.

### --question--

#### --text--

What is the purpose of the `--gradient-angle` custom property in this example?

```css
@property --gradient-angle {
  syntax: "<angle>";
  inherits: false;
  initial-value: 0deg;
}

.gradient {
  width: 100px;
  height: 100px;
  background: linear-gradient(var(--gradient-angle), red, blue);
  transition: --gradient-angle 0.5s;
}

.gradient:hover {
  --gradient-angle: 90deg;
}
```

#### --distractors--

It defines the speed of the gradient transition.

---

It specifies the size of the gradient.

---

It sets the color blending mode.

#### --answer--

It controls the direction of the gradient.

### --question--

#### --text--

Which scenario best shows the advantage of using custom properties for themes?

#### --distractors--

Using them just for font sizes.

---

Applying them only on `:hover`.

---

Restricting them to one CSS class.

#### --answer--

Changing values via class.

### --question--

#### --text--

Why might developers prefer using `:root` for defining CSS variables?

#### --distractors--

Because `:root` improves page load speed.

---

Because `:root` disables specificity.

---

Because `:root` is required for JavaScript.

#### --answer--

Because `:root` allows the properties to be globally scoped.

### --question--

#### --text--

What would the following CSS do if `--secondary-color` is undefined?

```css
h1 {
  color: var(--secondary-color, orange);
}
```

#### --distractors--

It will apply `black`.

---

It will ignore the `color` property.

---

It will apply `--secondary-color`.

#### --answer--

It will apply `orange`.

### --question--

#### --text--

What type of values does `<color>` represent in an `@property` syntax field?

#### --distractors--

Angles like `90deg`.

---

Lengths like `10px`.

---

Percentages like `50%`.

#### --answer--

Color values like `#ff0000` or `red`.

### --question--

#### --text--

What is the main benefit of using custom properties in combination with `@property`?

#### --distractors--

They prevent needing fallback values.

---

They force static layout.

---

They reduce the need for classes.

#### --answer--

They allow property animation.

### --question--

#### --text--

What does `var(--undefined-property, fallback)` do when the custom property is not defined?

#### --distractors--

Throws an error and stops applying styles.

---

Ignores the entire CSS rule.

---

Applies the variable name as is.

#### --answer--

Applies the fallback value instead.
