---
id: 67f412ac59601c4151b763da
title: Dictionaries and Sets Quiz
challengeType: 8
dashedName: quiz-dictionaries-and-sets
---

# --description--

To pass the quiz, you must correctly answer at least 18 of the 20 questions below.

# --quizzes--

## --quiz--

### --question--

#### --text--

What is a dictionary?

#### --distractors--

A data structure that only holds strings and lists.

---

A data structure that is a collection of key-value pairs that only accept large numbers.

---

A data structure that only holds a collection of tuples.

#### --answer--

A data structure that is a collection of key-value pairs.

### --question--

#### --text--

Which of the following is the correct syntax for a dictionary?

#### --distractors--

```py
dictionary = {
    <key1: value1>,
    <key2: value2>
}
```

---

```py
dictionary = {
    (key1: value1),
    (key2: value2)
}
```

---

```py
dictionary = {
    [key1: value1],
    [key2: value2]
}
```

#### --answer--

```py
dictionary = {
    key1: value1,
    key2: value2
}
```

### --question--

#### --text--

Which of the following is true about dictionaries?

#### --distractors--

Keys must be at least two characters in length.

---

Keys must include a special symbol.

---

Keys must include at least one number.

#### --answer--

Keys must be unique.

### --question--

#### --text--

Which of the following constructors can be used to create a dictionary?

#### --distractors--

`diction()`

---

`dic()`

---

`dictionary()`

#### --answer--

`dict()`

### --question--

#### --text--

Which of the following is the correct way to access a value from a dictionary?

#### --distractors--

`dictionary<key>`

---

`dictionary/key/`

---

`dictionary{key}`

#### --answer--

`dictionary[key]`

### --question--

#### --text--

Which of the following is the correct way to update a value in a dictionary?

#### --distractors--

`pizza['name'] >> 'Margherita'`

---

`pizza['name'] << 'Margherita'`

---

`pizza['name'] == 'Margherita'`

#### --answer--

`pizza['name'] = 'Margherita'`

### --question--

#### --text--

Which of the following methods can be used to retrieve a value associated with a key?

#### --distractors--

`access()`

---

`set()`

---

`retrieve()`

#### --answer--

`get()`

### --question--

#### --text--

What is a view object?

#### --distractors--

A special object used to turn strings into dictionaries.

---

A way to view the content of a dictionary only if the dictionary has two or more key-value pairs.

---

A special object used to turn lists into dictionaries.

#### --answer--

A way to see the content of a dictionary without creating a separate copy of the data.

### --question--

#### --text--

Which of the following methods returns a view object with all the key-value pairs in the dictionary?

#### --distractors--

`lists()`

---

`dictionaries()`

---

`collections()`

#### --answer--

`items()`

### --question--

#### --text--

Which of the following methods removes all of the key-value pairs from the dictionary?

#### --distractors--

`empty()`

---

`replace()`

---

`remove()`

#### --answer--

`clear()`

### --question--

#### --text--

What will be the output for the following code?

```py
products = {
    'Laptop': 990,
    'Smartphone': 600,
    'Tablet': 250,
    'Headphones': 70,
}

for product in products.items():
    print(product)
```

#### --distractors--

```py
<'Laptop', 990>
<'Smartphone', 600>
<'Tablet', 250>
<'Headphones', 70>
```

---

```py
'Laptop', 990
'Smartphone', 600
'Tablet', 250
'Headphones', 70
```

---

```py
['Laptop', 990]
['Smartphone', 600]
['Tablet', 250]
['Headphones', 70]
```

#### --answer--

```py
('Laptop', 990)
('Smartphone', 600)
('Tablet', 250)
('Headphones', 70)
```

### --question--

#### --text--

Which of the following is true about sets?

#### --distractors--

Sets are mutable and ordered in reverse.

---

Sets are mutable and ordered.

---

Sets are immutable and unordered.

#### --answer--

Sets are mutable and unordered.

### --question--

#### --text--

Which of the following is the correct way to create a set?

#### --distractors--

`my_set = (1, 2, 3, 4, 5)`

---

`my_set = <1, 2, 3, 4, 5>`

---

`my_set = [1, 2, 3, 4, 5]`

#### --answer--

`my_set = {1, 2, 3, 4, 5}`

### --question--

#### --text--

Which of the following functions is used to create an empty set?

#### --distractors--

`create_set()`

---

`empty_set()`

---

`sets()`

#### --answer--

`set()`

### --question--

#### --text--

What will be output to the terminal?

```py
my_set = {1, 2, 3, 4, 5, 6}
my_set.add(5)

print(my_set)
```

#### --distractors--

`SyntaxError`

---

`RangeError`

---

`{1, 2, 3, 4, 5, 5, 6}`

#### --answer--

`{1, 2, 3, 4, 5, 6}`

### --question--

#### --text--

Which of the following methods checks if a set is a subset? 

#### --distractors--

`issub()`

---

`isset()`

---

`subset()`

#### --answer--

`issubset()`

### --question--

#### --text--

Which of the following methods checks if two sets are disjoint?

#### --distractors--

`joint()`

---

`isjoint()`

---

`disjoint()`

#### --answer--

`isdisjoint()`

### --question--

#### --text--

What does the symmetric difference operator(`^`) do?

#### --distractors--

It returns a new set with only the elements that the sets have in common.

---

It finds the difference between the sets and updates the first set with that result.

---

It returns a new set with the elements of the first set that are not in the other set. 

#### --answer--

It returns a new set with the elements that are either in the first or the second set, but not both.

### --question--

#### --text--

Which of the following built-in modules is used for generating random numbers?

#### --distractors--

`set_random`

---

`get_random`

---

`rand`

#### --answer--

`random`

### --question--

#### --text--

Which of the following modules is used for working with regular expressions?

#### --distractors--

`regex`

---

`reg`

---

`r`

#### --answer--

`re`

