---
id: 66edd07682767adff3a6231e
title: DOM Manipulation and Click Events with JavaScript Quiz
challengeType: 8
dashedName: quiz-dom-manipulation-and-click-event-with-javascript
---

# --description--

To pass the quiz, you must correctly answer at least 18 of the 20 questions below.

# --quizzes--

## --quiz--

### --question--

#### --text--

What is the Document Object Model?

#### --distractors--

A programming language used to interact with an HTML page.

---

A set of objects that contain only floating point numbers.

---

A set of JavaScript classes representing HTML elements.

#### --answer--

A programming interface that lets you interact with HTML documents.

### --question--

#### --text--

What does API stand for?

#### --distractors--

Additional Programming Interface

---

Adding Programming Interface

---

Another Programming Interface

#### --answer--

Application Programming Interface

### --question--

#### --text--

How can you use JavaScript to find all HTML anchors with missing hyperlinks?

#### --distractors--

```js
document.findAll("link![href]");
```

---

```js
document.find("link:not([href])");
```

---

```js
document.querySelector("a![href]");
```

#### --answer--

```js
document.querySelectorAll("a:not([href])");
```

### --question--

#### --text--

What does the `textContent` property do?

#### --distractors--

It removes text content from all HTML elements.

---

It removes text content from your JavaScript file.

---

It adds text to all arrays and objects in your JavaScript file.

#### --answer--

It returns the plain text content of an element.

### --question--

#### --text--

What does the `innerHTML` property do?

#### --distractors--

It is a property of the `Element` used to get all text content for an HTML element.

---

It is a property of the `Element` used to add annotations to your HTML.

---

It is a property of the `Element` used to trigger events in your HTML. 

#### --answer--

It is a property of the `Element` used to set or update parts of the HTML markup.

### --question--

#### --text--

Which of the following will add a valid event listener?

#### --distractors--

```js
btn.addEventListener("accept", () => alert("You clicked the button"));
```

---

```js
btn.addEventListener("allow", () => alert("You clicked the button"));
```

---

```js
btn.addEventListener("trigger", () => alert("You clicked the button"));
```

#### --answer--

```js
btn.addEventListener("click", () => alert("You clicked the button"));
```

### --question--

#### --text--

Which of the following is NOT a valid method of the `document` object?

#### --distractors--

`getElementById()`

---

`querySelector()`

---

`createElement()` 

#### --answer--

`addElementToDOM()`

### --question--

#### --text--

Which of the following will set the `class` attribute to `my-class`?

#### --distractors--

```js
const para = document.getElementById("para");
para.setAttribute("set", "class");
```

---

```js
const para = document.getElementById("para");
para.setAttribute("remove", "my-class");
```

---

```js
const para = document.getElementById("para");
para.setAttribute("add", "class");
```

#### --answer--

```js
const para = document.getElementById("para");
para.setAttribute("class", "my-class");
```

### --question--

#### --text--

What is the `Event` object?

#### --distractors--

It is a special object used to remove events from your JavaScript project.

---

It is used to automatically add events to your JavaScript projects.

---

It is a special object used when working with arrays.

#### --answer--

It is a payload that triggers when a user interacts with your web page in some way. 

### --question--

#### --text--

Which of the following is a method used to remove an event listener that was previously added to an element using the `addEventListener()` method?

#### --distractors--

`removalOfEventListener()`

---

`removedEventListener()`

---

`removingEventListener()`

#### --answer--

`removeEventListener()`

### --question--

#### --text--

What are inline event handlers?

#### --distractors--

Special attributes on an HTML element that are used to cancel all events.

---

Special attributes on an HTML element used only to trigger form submissions in your JavaScript code.

---

Special attributes on an HTML element used to remove events.

#### --answer--

Special attributes on an HTML element that are used to execute JavaScript code when an event occurs.

### --question--

#### --text--

What are the two main categories for web APIs?

#### --distractors--

Java APIs and third-party APIs.

---

Browser APIs and Rust APIs.

---

System APIs and third-party APIs.

#### --answer--

Browser APIs and third-party APIs.

### --question--

#### --text--

Which event is triggered when all of the HTML page's elements have been parsed by the browser?

#### --distractors--

`load`

---

`DOMLoaded`

---

`HTMLContentLoaded`

#### --answer--

`DOMContentLoaded`

### --question--

#### --text--

Which of the following is a property that represents the inline style of an element?

#### --distractors--

`content`

---

`event`

---

`load`

#### --answer--

`style`

### --question--

#### --text--

Which of the following is the correct way to use an inline event handler?

#### --distractors--

```html
<button eventclick="validate()">Validate</button>
```

---

```html
<button click="validate()">Validate</button>
```

---

```html
<button clickevent="validate()">Validate</button>
```

#### --answer--

```html
<button onclick="validate()">Validate</button>
```

### --question--

#### --text--

Which of the following methods is used to delay an action for a specified time?

#### --distractors--

`setInterval()`

---

`delay()`

---

`sleep()`

#### --answer--

`setTimeout()`

### --question--

#### --text--

Which of the following can be used to create and control animations directly inside JavaScript?

#### --distractors--

Allow Animations API

---

Control Animations API 

---

Create Animations API

#### --answer--

Web Animations API 

### --question--

#### --text--

What does the Canvas API do?

#### --distractors--

It is used to animate graphics in your CSS file.

---

It is used to only remove graphics from your JavaScript file.

---

It is used to remove graphics from your HTML file.

#### --answer--

It is used to manipulate graphics via your JavaScript file.

### --question--

#### --text--

What is event delegation?

#### --distractors--

The process of listening to events when an event is canceled.

---

The process of listening to events when a click event occurs.

---

The process of listening to events when a change event occurs.

#### --answer--

The process of listening to events that have bubbled up to a parent.

### --question--

#### --text--

Which of the following is NOT a method you can use when working with dialogs and modals?

#### --distractors--

`show()`

---

`close()`

---

`showModal()`

#### --answer--

`removeModal()`

