---
id: 67358ac128957c865dcf3ddf
title: JavaScript Classes Quiz
challengeType: 8
dashedName: quiz-javascript-classes
---

# --description--

To pass the quiz, you must correctly answer at least 18 of the 20 questions below.

# --quizzes--

## --quiz--

### --question--

#### --text--

What is the purpose of a class in JavaScript?

#### --distractors--

To define only properties, not methods.

---

To define static variables only.

---

To organize only primitive data.

#### --answer--

To create reusable blueprints for objects.

### --question--

#### --text--

How do you define a class in JavaScript?

#### --distractors--

Using the `className` keyword.

---

Using the `object` keyword.

---

Using the `constructor` keyword only.

#### --answer--

Using the `class` keyword.

### --question--

#### --text--

Which method is used in a class to initialize properties?

#### --distractors--

`static`

---

`init`

---

`define`

#### --answer--

`constructor`

### --question--

#### --text--

What does `this` represent inside a class constructor?

#### --distractors--

The global class object.

---

The function itself.

---

An undefined reference.

#### --answer--

An instance of the class.

### --question--

#### --text--

Which of the following describes how `this` behaves in an arrow function inside a class method?

#### --distractors--

It inherits the value of `this` from the nearest function in a different scope.

---

It refers to a newly created instance of the class.

---

It inherits the value of `this` from the global object in strict mode.

#### --answer--

It inherits the value of `this` from the enclosing scope where it is defined.

### --question--

#### --text--

What is the primary purpose of the `extends` keyword?

#### --distractors--

To define static methods in a parent class constructor.

---

To create a method in a class.

---

To initialize default properties in the parent class.

#### --answer--

To create a subclass that inherits from a parent class.

### --question--

#### --text--

Which of the following is an example of how to create a `Car` class that inherits from a `Vehicle` class?

#### --distractors--

`class Car uses Vehicle {}`

---

`class Car = Vehicle {}`

---

`class Car inherits Vehicle {}`

#### --answer--

`class Car extends Vehicle {}`

### --question--

#### --text--

What is the output of the following code?

```javascript
class Animal {
  speak() {
    return "Animal speaks";
  }
}

class Dog extends Animal {
  speak() {
    return "Dog barks";
  }
}

const myDog = new Dog();
console.log(myDog.speak());
```

#### --distractors--

`Animal speaks`

---

An error is raised.

---

`undefined`

#### --answer--

`Dog barks`

### --question--

#### --text--

What is the function of the `super` keyword in a subclass?

#### --distractors--

To define a new instance of the parent class.

---

To delete methods and properties from the parent class.

---

To access only the static methods of the parent class.

#### --answer--

To call the constructor or methods of the parent class.

### --question--

#### --text--

Which of the following describes a static method?

#### --distractors--

A method that is inaccessible inside the class itself.

---

A method that is used only in arrow functions.

---

A method that is unique to each instance of a class.

#### --answer--

A method that belongs to the class itself, not to any instance.

### --question--

#### --text--

What will the following code output?

```js
class Calculator {
  static add(a, b) {
    return a + b;
  }
}

console.log(Calculator.add(3, 4));
```

#### --distractors--

An error is raised.

---

`undefined`

---

`NaN`

#### --answer--

`7`

### --question--

#### --text--

How would you access a static property in JavaScript class?

#### --distractors--

By using `this.propertyName` within a method.

---

By using `instance.propertyName` after creating an instance.

---

By using `super.propertyName` within a subclass.

#### --answer--

By using `ClassName.propertyName`.

### --question--

#### --text--

In which scenario would you use a static method over an instance method?

#### --distractors--

When you need to access and modify the instance's properties.

---

When the method needs to be called on an object instance.

---

When the method doesn't rely on instance-specific data and operates on class-level data.

#### --answer--

When the method operates on data that is shared by all instances of the class.

### --question--

#### --text--

What will the following code output?

```js
class MyClass {
  sayHello() {
    return "Hello!";
  }
}

console.log(MyClass.sayHello());
```

#### --distractors--

`Hello!`

---

`null`

---

`undefined`

#### --answer--

It throws an error.

### --question--

#### --text--

What keyword is used to inherit properties and methods from another class?

#### --distractors--

`import`

---

`inherit`

---

`static`

#### --answer--

`extends`

### --question--

#### --text--

What is printed by the following code?

```js
class Person {
  static species = "Human";
}

console.log(Person.species);
```

#### --distractors--

`undefined`

---

`null`

---

An error is raised.

#### --answer--

`Human`

### --question--

#### --text--

Which of the following best describes inheritance?

#### --distractors--

It allows a method to return a new object.

---

It allows an instance to define its own properties.

---

It allows a static property to be converted into a non-static property.

#### --answer--

It allows a class to acquire properties and methods from another class.

### --question--

#### --text--

What happens if a constructor is not defined in a subclass?

#### --distractors--

An error will be thrown.

---

The subclass will inherit the constructor from any class in the code.

---

The subclass cannot create new instances.

#### --answer--

The superclass's constructor will be used by default.

### --question--

#### --text--

What does `this` represent in the following code?

```js
class Animal {
  constructor(name) {
    this.name = name;
  }
}
```

#### --distractors--

The global object.

---

The `Animal` class itself.

---

An undefined variable.

#### --answer--

The instance of `Animal`.

### --question--

#### --text--

What is the primary use of static properties?

#### --distractors--

To define default properties for each class instance.

---

To override methods in a subclass.

---

To define instance-specific data.

#### --answer--

To store class-wide data shared across instances.
