---
id: 67f41242431cbf3db8ca79c7
title: Python Basics Quiz
challengeType: 8
dashedName: quiz-python-basics
---

# --description--

To pass the quiz, you must correctly answer at least 18 of the 20 questions below.

# --quizzes--

## --quiz--

### --question--

#### --text--

Which of the following functions is used to check if a variable matches a specific data type?

#### --distractors--

`istype()`

---

`isdata()`

---

`isvariable()`

#### --answer--

`isinstance()`

### --question--

#### --text--

Which of the following is NOT a form of string concatenation?

#### --distractors--

```py
greeting = 'My name is '
developer = 'Jessica'

greeting += developer
```

---

```py
developer = 'Jessica'
greeting = 'My name is ' + developer + '.'
```

---

```py
developer = 'Jessica'
age = 30
greeting = 'My name is ' + developer + ' and I am ' + str(age) + ' years old.'
```

#### --answer--

```py
developer = 'Jessica'
greeting = x'My name is {developer}.'
```

### --question--

#### --text--

Which of the following functions is used to return the number of the characters in the string?

#### --distractors--

`counting()`

---

`length()`

---

`iscount()`

#### --answer--

`len()`

### --question--

#### --text--

What will `result` be in this example?

```py
developer = 'Naomi'

result = developer.endswith('N') # ?
```

#### --distractors--

`Undefined`

---

`True`

---

`None`

#### --answer--

`False`

### --question--

#### --text--

What happens when you add a float and an integer?

#### --distractors--

The result will be an error message.

---

The result will be `None`.

---

The result will be an integer.

#### --answer--

The result will be a float.

### --question--

#### --text--

Which of the following is the correct way to define a function?

#### --distractors--

```py
define get_sum(num_1, num_2) {
    return num_1 + num_2 
} 
```

---

```py
set get_sum(num_1, num_2):
    return num_1 + num_2
```

---

```py
function get_sum(num_1, num_2) {
    return num_1 + num_2 
}
```

#### --answer--

```py
def get_sum(num_1, num_2):
    return num_1 + num_2
```

### --question--

#### --text--

What will be printed to the console?

```py
def greet():
    pass
    
print(greet()) # ?
```

#### --distractors--

`TypeError`

---

`RangeError`

---

`Null`

#### --answer--

`None`

### --question--

#### --text--

Which of the following statements is false when naming variables?

#### --distractors--

Variable names can only start with a letter or an underscore (_), not a number.

---

Variable names can only contain alphanumeric characters (a-z, A-Z, 0-9) and underscores (_).

---

Variable names cannot be one of Python's reserved keywords such as `if`, `class`, or `def`.

#### --answer--

Variable names must have a max length of 10 characters, otherwise Python will throw an error.

### --question--

#### --text--

Which of the following is NOT a supported data type in Python?

#### --distractors--

`None`

---

`int`

---

`float`

#### --answer--

`Generic`

### --question--

#### --text--

Which of the following will return a new string with all characters converted to uppercase?

#### --distractors--

```py
developer = 'Jessica'

print(developer.isupper()) # JESSICA
```

---

```py
developer = 'Jessica'

print(developer.up()) # JESSICA
```

---

```py
developer = 'Jessica'

print(developer.toUpper()) # JESSICA
```

#### --answer--

```py
developer = 'Jessica'

print(developer.upper()) # JESSICA
```

### --question--

#### --text--

Which of the following functions is used to get input from a user?

#### --distractors--

`read()`

---

`cout()`

---

`prompt()`

#### --answer--

`input()`

### --question--

#### --text--

What will be the result for the following code?

```py
message = 'Python is fun!'

print(message[0:6])  # ?
```

#### --distractors--

`'Py'`

---

`'fun'`

---

`'is'`

#### --answer--

`'Python'`

### --question--

#### --text--

What does the `split()` method do?

#### --distractors--

This method is used to split a tuple into a list of substrings.

---

This method is used to split a float into a list of substrings.

---

This method is used to split a dictionary into a list of substrings.

#### --answer--

This method is used to split a string into a list of substrings.

### --question--

#### --text--

What will the following print to the console?

```py
example_list = ['example', 'dashed', 'name']

joined_str = ' '.join(example_list)
print(joined_str)  # ?
```

#### --distractors--

`TypeError`

---

`'dashed name'`

---

`None`

#### --answer--

`'example dashed name'`

### --question--

#### --text--

Which of the following functions is used to create a table of 1 to 1 character mappings for translation?

#### --distractors--

`str.translations()`

---

`str.gettranslate()`

---

`str.tran()`

#### --answer--

`str.maketrans()`

### --question--

#### --text--

What will be the result for the following code?

```py
int_1 = 4
int_2 = 2

print(int_1 ** int_2) # ?
```

#### --distractors--

8

---

2

---

4

#### --answer--

16

### --question--

#### --text--

What will be returned from the `find()` method if no substring occurrences are found in a string?

#### --distractors--

-2

---

1

---

0

#### --answer--

-1

### --question--

#### --text--

Which of the following functions is used to count the times a substring appears in a string?

#### --distractors--

`counter()`

---

`hascount()`

---

`counting()`

#### --answer--

`count()`

### --question--

#### --text--

What does floor division do in Python?

#### --distractors--

This operator is used to multiply two numbers and round up the result to the nearest whole number.

---

This operator is used to convert a float to an integer.

---

This operator is used to raise a number to the power of another.

#### --answer--

This operator is used to divide two numbers and round down the result to the nearest whole number.

### --question--

#### --text--

Which of the following functions is used to round a number to the nearest whole integer?

#### --distractors--

`floor()`

---

`ceil()`

---

`float()`

#### --answer--

`round()`

