---
id: 66f1ad049d7a6ac0886cc2ba
title: React Forms, Data Fetching and Routing Quiz
challengeType: 8
dashedName: quiz-react-forms-data-fetching-and-routing
---

# --description--

To pass the quiz, you must correctly answer at least 18 of the 20 questions below.

# --quizzes--

## --quiz--

### --question--

#### --text--

Which of the following is an example of a controlled input?

#### --distractors--

```jsx
<input id="name" type="text" />
```

---

```jsx
<input id="name" onChange={handleChange} type="text" />
```

---

```jsx
<input value="" id="name" type="text" />
```

#### --answer--

```jsx
<input value={name} id="name" onChange={handleChange} type="text" />
```

### --question--

#### --text--

Which of the following is an example of an uncontrolled input?

#### --distractors--

```jsx
<input type="text" references={nameRef} id="name" />
```

---

```jsx
<input type="text" refs={nameRef} id="name" />
```

---

```jsx
<input type="text" reference={nameRef} id="name" />
```

#### --answer--

```jsx
<input type="text" ref={nameRef} id="name" />
```

### --question--

#### --text--

Which of the following is NOT a commonly used way to fetch data in React?

#### --distractors--

SWR

---

Axios

---

Fetch API

#### --answer--

Redux

### --question--

#### --text--

Which of the following hooks is commonly associated with fetching data in React?

#### --distractors--

`useParams`

---

`useContext`

---

`useReducer`

#### --answer--

`useEffect`

### --question--

#### --text--

What is memoization?

#### --distractors--

A common algorithm used to find the shortest path between two vertices in a graph.

---

A special technique used to optimize the performance for all controlled and uncontrolled inputs.

---

A divide and conquer algorithm used to recursively sort sub arrays and merge them together.

#### --answer--

An optimization technique in which the result of expensive function calls are cached (remembered) based on specific arguments.

### --question--

#### --text--

Which of the following hooks is used to memoize computed values?

#### --distractors--

`useParams`

---

`useEffect`

---

`useState`

#### --answer--

`useMemo`

### --question--

#### --text--

Which of the following uses the correct hook to memoize function references?

#### --distractors--

```js
useContext(() => {
 // code goes here
}, [dependency]);
``` 

---

```js
useParams(() => {
 // code goes here
}, [dependency]);
``` 

---

```js
useState(() => {
 // code goes here
}, [dependency]);
``` 

#### --answer--

```js
useCallback(() => {
 // code goes here
}, [dependency]);
``` 

### --question--

#### --text--

What is a dependency?

#### --distractors--

A dependency is a commonly used testing library used in React applications.

---

A dependency is a type of React component that only runs on the server.

---

A dependency is a special compiler used in React applications to compile the React code into JavaScript. 

#### --answer--

A dependency is where one component or module in an application relies on another to function properly.

### --question--

#### --text--

What is a package manager?

#### --distractors--

A tool used to update third-party packages installed in applications.

---

A tool used to manage packages solely created within a project.

---

A tool used to move dependencies out of the `node_modules` folder and into a special config folder.

#### --answer--

A tool used for installation, updates and removal of dependencies.

### --question--

#### --text--

Which of the following is NOT a commonly used package manager in the JavaScript ecosystem?

#### --distractors--

pnpm

---

Yarn

---

npm

#### --answer--

Jest

### --question--

#### --text--

Which of the following is a key configuration file that contains metadata about your project?

#### --distractors--

`config.json`

---

`lint.json`

---

`node_modules.json`

#### --answer--

`package.json`

### --question--

#### --text--

Which of the following is a commonly used React framework?

#### --distractors--

Django

---

Webpack

---

Gulp

#### --answer--

Remix

### --question--

#### --text--

Which of the following is the correct way to add routes to your React application using React Router?

#### --distractors--

```jsx
<StrictMode>
  <AddRouter>
    <Routes>
      <Route path="/" element={<App />} />
    </Routes>
  </AddRouter>
</StrictMode>
```

---

```jsx
<StrictMode>
  <ContextRouter>
    <Routes>
      <Route path="/" element={<App />} />
    </Routes>
  </ContextRouter>
</StrictMode>
```

---

```jsx
<StrictMode>
  <SetRoute>
    <Routes>
      <Route path="/" element={<App />} />
    </Routes>
  </SetRoute>
</StrictMode>
```

#### --answer--

```jsx
<StrictMode>
  <BrowserRouter>
    <Routes>
      <Route path="/" element={<App />} />
    </Routes>
  </BrowserRouter>
</StrictMode>
```

### --question--

#### --text--

Which of the following is the correct way to create a dynamic route in React Router?

#### --distractors--

```jsx
<Route path="?category" element={<Category />} />
```

---

```jsx
<Route path="<category" element={<Category />} />
```

---

```jsx
<Route path="/category" element={<Category />} />
```

#### --answer--

```jsx
<Route path=":category" element={<Category />} />
```

### --question--

#### --text--

Which of the following hooks is used to access the dynamic parameters from a URL path?

#### --distractors--

`useParameterized`

---

`usePar`

---

`useParameters`

#### --answer--

`useParams`

### --question--

#### --text--

Which of the following is the correct way to create a custom request handler in Next.js?

#### --distractors--

```js
export async function SERVE() {
  const res = await fetch("https://example-api.com");
  const data = await res.json();

  return Response.json({ data });
}
```

---

```js
export async function FETCH() {
  const res = await fetch("https://example-api.com");
  const data = await res.json();

  return Response.json({ data });
}
```

---

```js
export async function SET() {
  const res = await fetch("https://example-api.com");
  const data = await res.json();

  return Response.json({ data });
}
```

#### --answer--

```js
export async function GET() {
  const res = await fetch("https://example-api.com");
  const data = await res.json();

  return Response.json({ data });
}
```

### --question--

#### --text--

What is prop drilling?

#### --distractors--

The process of creating a reducer that specifies how state should change in response to particular props used.

---

The process of passing props from child component up to the parent component. 

---

The process of creating a context provider for a React application and using that to send props from parent to child components.

#### --answer--

The process of passing props from a parent component to deeply nested child components, even when some of the child components don't need the props.

### --question--

#### --text--

Which of the following is NOT a commonly used state management solution for React applications?

#### --distractors--

Context API

---

Zustand

---

Redux

#### --answer--

Spring

### --question--

#### --text--

What are the React Developer Tools used for?

#### --distractors--

These tools are used to only check for accessibility issues in React applications.

---

These tools are used to add additional tests for React components.

---

These tools are used to memoize all React components inside the application.

#### --answer--

These tools are used to inspect React components and identify performance issues.

### --question--

#### --text--

What are React Server Components?

#### --distractors--

These are components that manage context exclusively on the server.

---

These are memoized components that render exclusively on the server.

---

These are components that manage state exclusively on the server.

#### --answer--

These are components that render exclusively on the server.

