---
id: 66f1a417757b6ca4eecd89d6
title: React State and Hooks Quiz
challengeType: 8
dashedName: quiz-react-state-and-hooks
---

# --description--

To pass the quiz, you must correctly answer at least 18 of the 20 questions below.

# --quizzes--

## --quiz--

### --question--

#### --text--

Which of the following is the correct way to add a click event to a button in React?

#### --distractors--

```jsx
<button onClick={{ handleLoginClick }} />
```

---

```jsx
<button onclick={handleLoginClick} />
```

---

```jsx
<button onClick={handleLoginClick()} />
```

#### --answer--

```jsx
<button onClick={handleLoginClick} />
```

### --question--

#### --text--

What is a React Synthetic Event?

#### --distractors--

A type of JSX element for `inputs` and `submit` events only.

---

A type of JSX element for `submit` events only.

---

A way to alter the bubbling phase of event propagation to be more user friendly.

#### --answer--

A wrapper around native events like `click` and `submit` events.

### --question--

#### --text--

Which of the following is a common prefix used for naming event handler functions?

#### --distractors--

isHandling

---

hasHandled

---

handling

#### --answer--

handle

### --question--

#### --text--

What are the three major stages in React's rendering?

#### --distractors--

Handshake, loading and hydration.

---

Fetching, decoding and execution.

---

Mounting, updating and unmounting.

#### --answer--

Triggering, rendering and committing.

### --question--

#### --text--

Which of the following is the correct way to work with the `useState` hook?

#### --distractors--

```js
const [count, setCount] = useState<0>;
```

---

```js
const <count, setCount> = useState(0);
```

---

```js
const count, setCount = useState(0);
```

#### --answer--

```js
const [count, setCount] = useState(0);
```

### --question--

#### --text--

Which of the following is NOT a valid attribute used for handling React events?

#### --distractors--

`onChange`

---

`onClick`

---

`onSubmit`

#### --answer--

`onHandle`

### --question--

#### --text--

Which of the following is the correct way to update array state?

```js
const [certificates, setCertificates] = useState([]);
```

#### --distractors--

```js
setCertificates(previousItems => previousItems, "Front End");
```

---

```js
setCertificates.push("Front End");
```

---

```js
setCertificates().append("Front End");
```

#### --answer--

```js
setCertificates(previousItems => [...previousItems, "Front End"]);
```

### --question--

#### --text--

What is wrong with this function?

```js
function updateSpaceship() {
  setSpaceship(previousState => ({
    name: "Discovery"
  }));
}
```

#### --distractors--

Updating a `useState` variable is not allowed inside a nested function.

---

`previousState` needs to be surrounded by parenthesis.

---

Arrow functions should not be used inside a state setter function.

#### --answer--

`previousState` must be spread before `name` to ensure any other properties are not overwritten.

### --question--

#### --text--

Which of the following is the correct way to update state to remove items from an array?

#### --distractors--

```js
const removeItem = (id) => {
  setItems((prevItems) => prevItems.reduce((item) => item.id));
};
```

---

```js
const removeItem = (id) => {
  setItems((prevItems) => prevItems.map((item) => item.id !== id));
};
```

---

```js
const removeItem = (id) => {
  setItems(() => delete item.id !== id);
};
```

#### --answer--

```js
const removeItem = (id) => {
  setItems((prevItems) => prevItems.filter((item) => item.id !== id));
};
```

### --question--

#### --text--

What is the `ref` attribute typically used for in React?

#### --distractors--

It is used to audit for performance issues in react components.

---

It is used to audit for accessibility issues in react components.

---

It is used to remove DOM nodes.

#### --answer--

It is used to access a DOM node.

### --question--

#### --text--

Which of the following is the correct way to access the current value for a `ref`?

#### --distractors--

```js
const inputRef = useRef(null);
inputRef.initial
```

---

```js
const inputRef = useRef(null);
inputRef.val
```

---

```js
const inputRef = useRef(null);
inputRef.curr
```

#### --answer--

```js
const inputRef = useRef(null);
inputRef.current
```

### --question--

#### --text--

How many times will this message be logged to the console?

```js
useEffect(() => {
  console.log("Nice work!!");
}, []);
```

#### --distractors--

Three times.

---

Twice.

---

None as the dependency array is empty.

#### --answer--

Only once on initial render.

### --question--

#### --text--

What are React custom hooks typically used for?

#### --distractors--

They are used to execute an app's most complex functionality.

---

They are not typically used, built-in hooks are preferred.

---

They replace life cycle methods from previous versions of React.

#### --answer--

They are helpful for reusing stateful logic across components.

### --question--

#### --text--

How many times will this message get logged to the console?

```js
useEffect(() => {
  console.log("I love freeCodeCamp!");
});
```

#### --distractors--

It will be logged anytime a form is submitted or a click event happens.

---

It will be logged twice.

---

It will only get logged once.

#### --answer--

It will be logged each time the component renders.

### --question--

#### --text--

Which of the following is the correct way to prevent a browser refresh for an `onSubmit` event?

#### --distractors--

```jsx
function handleSubmit(event) {
  event.defaultPrevent();
  console.log("Form submitted!");
}

<form onSubmit={handleSubmit}>
  <input type="text" />
  <button>Submit</button>
</form>;
```

---

```jsx
function handleSubmit(event) {
  event.Default();
  console.log("Form submitted!");
}

<form onSubmit={handleSubmit}>
  <input type="text" />
  <button>Submit</button>
</form>;
```

---

```jsx
function handleSubmit(event) {
  event.prevent();
  console.log("Form submitted!");
}

<form onSubmit={handleSubmit}>
  <input type="text" />
  <button>Submit</button>
</form>;
```

#### --answer--


```jsx
function handleSubmit(event) {
  event.preventDefault();
  console.log("Form submitted!");
}

<form onSubmit={handleSubmit}>
  <input type="text" />
  <button>Submit</button>
</form>;
```

### --question--

#### --text--

Which of the following hooks is typically used to fetch data?

#### --distractors--

`useReducer`

---

`useState`

---

`useDebounce`

#### --answer--

`useEffect`

### --question--

#### --text--

Which of the following is NOT a valid property on the native Event object?

#### --distractors--

`currentTarget`

---

`type`

---

`target`

#### --answer--

`prop`

### --question--

#### --text--

Which of the following rendering stages occurs when React detects that something has changed and the user interface (UI) might need to be updated?

#### --distractors--

setter

---

commit

---

loop

#### --answer--

trigger

### --question--

#### --text--

Which of the following stages refers to when React takes the prepared changes from the virtual DOM and applies them to the real DOM?

#### --distractors--

trigger

---

render

---

setter

#### --answer--

commit

### --question--

#### --text--

What is the purpose of the `dependencies` in a `useEffect`?

```js
useEffect(() => {
  // Your side effect logic (usually a function) goes here
}, [dependencies]);
```

#### --distractors--

The optional `dependencies` argument does not effect anything dealing with the `useEffect`.

---

The optional `dependencies` argument makes the effect run on an infinite loop.

---

The optional `dependencies` argument is used to prevent the effect from running.

#### --answer--

The optional `dependencies` argument controls when the effect runs.

