---
id: 66edd43cded6bff30944b676
title: Recursion Quiz
challengeType: 8
dashedName: quiz-recursion
---

# --description--

To pass the quiz, you must correctly answer at least 9 of the 10 questions below.

# --quizzes--

## --quiz--

### --question--

#### --text--

What is recursion in programming?

#### --distractors--

A method of sorting arrays.

---

A loop that never ends.

---

A function that returns `undefined`.

#### --answer--

A process in which a function calls itself.

### --question--

#### --text--

Which of the following is an example of recursion?

#### --distractors--

```js
function factorial(n) {
  let result = 1;

  while (n > 0) {
    result = result * n;
    n--;
  }

  return result;
}
```

---

```js
function factorial(n) {
  const arr = Array(n).fill().map((_, i) => i + 1);
  return arr.reduce((acc, curr) => acc * curr, 1);
}
```

---

```js
function factorial(n) {
  let result = 1;

  for (let i = n; i > 0; i--) {
    result *= i;
  }

  return result;
}
```

#### --answer--

```js
function factorial(n) {
  if (n === 0 || n === 1) {
    return 1;
  }
  return n * factorial(n - 1);
}
```

### --question--

#### --text--

What will the following function return?

```js
function sum(n) {
  if (n === 0) return 0;
  return n + sum(n - 1);
}
sum(3);
```

#### --distractors--

3

---

0

---

1

#### --answer--

6

### --question--

#### --text--

How many times will the `mystery` function be called?

```javascript
function mystery(n) {
  if (n <= 1) return 1;
  return mystery(n - 2);
}
mystery(5);
```

#### --distractors--

2

---

5

---

4

#### --answer--

3

### --question--

#### --text--

Which of the following is true about recursion?

#### --distractors--

It should never have a base case.

---

It should only be used for the Fibonacci sequence. 

---

It should only be used for factorials.

#### --answer--

It should always have a base case.

### --question--

#### --text--

Which of the following options would be an appropriate base case for the given example?

```js
function countDownToZero(number) {
  // Base case goes here.

  console.log(number);
  countDownToZero(number - 1);
}
```

#### --distractors--

```js
if (number > 0) {
  return;
}
```

---

```js
if (number !== 0) {
  return;
}
```

---

```js
if (number === 0) {
  return;
}
```

#### --answer--

```js
if (number < 0) {
  return;
}
```

### --question--

#### --text--

Why must recursion have a base case?

#### --distractors--

To ensure the function always has a return value.

---

To reduce the number of function calls.

---

To ensure all recursive calls are executed in the correct order and a `RecursionError` is not thrown.

#### --answer--

To provide a way for the function to break out of its recursive calls and prevent infinite loops.

### --question--

#### --text--

What will this recursive function do?

```js
function repeatString(str) {
  return str + repeatString(str);
}
```

#### --distractors--

Return the string twice.

---

Return `undefined`.

---

Create an empty string.

#### --answer--

Cause a stack overflow.

### --question--

#### --text--

What is a call stack?

#### --distractors--

A list of function calls that have been executed.

---

A list of values that were returned by a function.

---

A special function used to call a function exactly three times.

#### --answer--

A data structure that keeps track of function calls and their execution order.

### --question--

#### --text--

What does this recursive function do?

```js
function changeString(str) {
  if (str === "") return "";
  return changeString(str.slice(1)) + str[0];
}
```

#### --distractors--

Duplicates a string.

---

Removes vowels.

---

Removes spaces.

#### --answer--

Reverses a string.

