---
id: 66ed9034f45ce3ece4053ebd
title: Responsive Web Design Quiz
challengeType: 8
dashedName: quiz-responsive-web-design
---

# --description--

To pass the quiz, you must correctly answer at least 18 of the 20 questions below.

# --quizzes--

## --quiz--

### --question--

#### --text--

What are breakpoints in responsive web design?

#### --distractors--

Specific points in a design where floats overlap with other elements on the page.

---

Specific points used to set the columns and rows for a grid or flex layout.

---

Specific points used to determine how a tabular layout will behave on the page.

#### --answer--

Specific points in a design where the layout and content adjust to accommodate different screen sizes.

### --question--

#### --text--

Which of the following is NOT a breakpoint used for smaller devices?

#### --distractors--

`600px`

---

`480px`

---

`320px`

#### --answer--

`960px`

### --question--

#### --text--

What is the main purpose of using media queries in responsive web design?

#### --distractors--

To change the color scheme of the page for Safari browsers.

---

To create animations for table layouts.

---

To adjust margins and padding for layouts using CSS flexbox.

#### --answer--

To apply different styles based on the screen size or device type.

### --question--

#### --text--

Which media feature in a media query checks the width of the browser window?

#### --distractors--

`set-width`

---

`accept-width`

---

`allow-width`

#### --answer--

`min-width`

### --question--

#### --text--

What will the following code do?

```css
@media screen and (min-width: 768px) {
  /* Styles go here */
}
```

#### --distractors--

This will ignore styles for screens that are `768px` wide.

---

This will apply styles for screens that are only `768px` wide.

---

This will apply styles for screens that are smaller than `768px`.

#### --answer--

This will apply styles for screens that are `768px` and wider.

### --question--

#### --text--

What does mobile-first design emphasize?

#### --distractors--

Designing for smaller devices only and ignoring the others.

---

Designing for mobile devices built by Apple only.

---

Designing for smaller Android screens first and ignoring Apple devices.

#### --answer--

Designing for smaller screens first and scaling up for larger devices.

### --question--

#### --text--

Which media query will apply styles when the device's width is between 600px and 1200px?

#### --distractors--

`@media screen and (max-width: 1200px)`

---

`@media screen and (min-width: 600px)`

---

`@media screen and (width: 800px)`

#### --answer--

`@media screen and (min-width: 600px) and (max-width: 1200px)`

### --question--

#### --text--

Which of the following is NOT a valid media type?

#### --distractors--

`all`

---

`print`

---

`screen`

#### --answer--

`poster`

### --question--

#### --text--

Which of the following media types is intended for paged material and documents viewed on a screen in print preview mode?

#### --distractors--

`aspect-ratio`

---

`flex`

---

`screen`

#### --answer--

`print`

### --question--

#### --text--

What does the `aspect-ratio` do in media queries?

#### --distractors--

It describes the ratio between flex properties in a flex layout.

---

It describes the ratio between the x and y axis for grid containers.

---

It describes the ratio between rows and columns for table layouts.

#### --answer--

It describes the ratio between the width and height of the viewport.

### --question--

#### --text--

Which of the following is used to indicate whether the device is in landscape or portrait orientation?

#### --distractors--

`apply-orientation`

---

`set-orientation`

---

`oriente`

#### --answer--

`orientation`

### --question--

#### --text--

Which of the following is commonly used to target desktop screens and larger?

#### --distractors--

```css
@media screen and (min-width: 140000px) {
  /* Styles go here */
}
```

---

```css
@media screen and (min-width: 140px) {
  /* Styles go here */
}
```

---

```css
@media screen and (min-width: 14000px) {
  /* Styles go here */
}
```

#### --answer--

```css
@media screen and (min-width: 1400px) {
  /* Styles go here */
}
```

### --question--

#### --text--

Which of the following is used to detect if the user has requested a light or dark color theme?

#### --distractors--

`allow-colors-scheme`

---

`apply-color-scheme`

---

`set-colors-scheme`

#### --answer--

`prefers-color-scheme`

### --question--

#### --text--

Which of the following is used to test whether the primary input mechanism can hover over elements?

#### --distractors--

```css
@media (set: hover) {
  /* Styles for devices that support hover */
}
```

---

```css
@media (apply: hover) {
  /* Styles for devices that support hover */
}
```

---

```css
@media (hover: apply) {
  /* Styles for devices that support hover */
}
```

#### --answer--

```css
@media (hover: hover) {
  /* Styles for devices that support hover */
}
```

### --question--

#### --text--

Which of the following is NOT a type of logical operator you can use with media queries?

#### --distractors--

`only`

---

`not`

---

`and`

#### --answer--

`accept`

### --question--

#### --text--

Which of the following breakpoints is commonly used for tablets in responsive web design?

#### --distractors--

`480px`

---

`1920px`

---

`2560px`

#### --answer--

`768px`

### --question--

#### --text--

Which of the following is the correct way to apply the `aspect-ratio` in a media query?

#### --distractors--

```css
@media screen and (aspect-ratio: 16-9) {
  /* Styles for screens with a 16:9 aspect ratio */
}
```

---

```css
@media screen and (aspect-ratio: 16=9) {
  /* Styles for screens with a 16:9 aspect ratio */
}
```

---

```css
@media screen and (aspect-ratio: 16:9) {
  /* Styles for screens with a 16:9 aspect ratio */
}
```

#### --answer--

```css
@media screen and (aspect-ratio: 16/9) {
  /* Styles for screens with a 16:9 aspect ratio */
}
```

### --question--

#### --text--

Which CSS property is used to create a layout that adjusts based on screen size without media queries?

#### --distractors--

`float`

---

`display: block;`

---

`width: 100%;`

#### --answer--

`flex`

### --question--

#### --text--

Which of the following can be used to target landscape screens `768px` and larger?

#### --distractors--

```css
@media screen and (min-width: 768px) and (landscape: orientation) {
  /* Styles go here */
}
```

---

```css
@media screen and (max-width: 768px) and (orientation: landscape) {
  /* Styles go here */
}
```

---

```css
@media screen and (min-width: 768px) and (landscape: set) {
  /* Styles go here */
}
```

#### --answer--

```css
@media screen and (min-width: 768px) and (orientation: landscape) {
  /* Styles go here */
}
```

### --question--

#### --text--

What is the default media type if no media type is specified?

#### --distractors--

`screen`

---

`mobile`

---

`print`

#### --answer--

`all`

## --quiz--

### --question--

#### --text--

Which CSS unit is commonly used in responsive design to create fluid layouts?

#### --distractors--

`px`

---

`em`

---

`rem`

#### --answer--

`%`

### --question--

#### --text--

What is the primary purpose of using media queries in responsive web design?

#### --distractors--

To apply different styles based on user input

---

To make the website load faster

---

To change the website’s color scheme automatically

#### --answer--

To adjust the layout and design based on screen size

### --question--

#### --text--

Which CSS `width` value causes an element to scale proportionally with the width of its parent container, making it suitable for responsive design?

#### --distractors--

`auto`

---

`100vh`

---

`fit-content`

#### --answer--

`100%`

### --question--

#### --text--

Which of the following is an example of a media feature that can be used in a media query?

#### --distractors--

`background-color`

---

`font-size`

---

`text-align`

#### --answer--

`min-width`

### --question--

#### --text--

What does the `@media screen and (max-width: 768px)` media query apply to?

#### --distractors--

It applies styles to screens larger than 768px wide.

---

It applies styles to all screens, regardless of size.

---

It applies styles to screens with a resolution greater than 768dpi.

#### --answer--

It applies styles to screens smaller than 768px wide.

### --question--

#### --text--

Which of the following media query features targets devices with a screen resolution of at least 300dpi?

#### --distractors--

`@media screen and (min-width: 300dpi)`

---

`@media screen and (resolution: 300dpi)`

---

`@media screen and (min-res: 300dpi)`

#### --answer--

`@media screen and (min-resolution: 300dpi)`

### --question--

#### --text--

Which of the following media features would you use to apply styles only when a device does not support hover interactions?

#### --distractors--

`@media (hover: hover)`

---

`@media (hover: auto)`

---

`@media (no-hover: false)`

#### --answer--

`@media (hover: none)`

### --question--

#### --text--

Which of the following is a valid way to target devices with a portrait orientation using a media query?

#### --distractors--

`@media screen and (orientation: landscape) { ... }`

---

`@media (orientation: portrait) { ... }`

---

`@media screen and (min-orientation: portrait) { ... }`

#### --answer--

`@media screen and (orientation: portrait) { ... }`

### --question--

#### --text--

Which media query feature is used to apply styles based on the resolution of the device?

#### --distractors--

`@media (resolution: high) { ... }`

---

`@media screen and (resolution: 300dpi) { ... }`

---

`@media (min-resolution: 150) { ... }`

#### --answer--

`@media (min-resolution: 300dpi) { ... }`

### --question--

#### --text--

What is the purpose of the `@media (hover: hover)` query in CSS?

#### --distractors--

It applies styles only on touch devices.

---

It changes styles based on device orientation.

---

It detects if the device uses a touchscreen.

#### --answer--

It checks if a device supports mouse hover.

### --question--

#### --text--

Which media feature allows you to apply styles only on high pixel density screens like Retina displays?

#### --distractors--

`device-type`

---

`aspect-ratio`

---

`min-width`

#### --answer--

`min-resolution`

### --question--

#### --text--

Which keyword can be used in media queries to combine multiple conditions?

#### --distractors--

if

---

then

---

combine

#### --answer--

and

### --question--

#### --text--

Which CSS technique is commonly used with media queries to apply styles only under specific conditions?

#### --distractors--

Using inline styles for all elements

---

Using JavaScript to detect screen size and apply classes

---

Linking to different HTML files for mobile and desktop

#### --answer--

Combining media features using logical operators like `and` in media queries

### --question--

#### --text--

Which CSS technique helps ensure images scale proportionally on different screen sizes?

#### --distractors--

Using fixed pixel widths for images

---

Setting images as background elements

---

Applying inline styles with exact dimensions

#### --answer--

Setting the image width to a percentage like `width: 100%`

### --question--

#### --text--

What is the purpose of the `@media screen and (min-resolution: 300dpi)` query?

#### --distractors--

To apply styles for screens with a low pixel density.

---

To apply styles based on the screen’s width.

---

To apply styles based on the device's resolution in pixels.

#### --answer--

To apply styles for screens with a high pixel density.

### --question--

#### --text--

Which of the following is true about the mobile-first approach in responsive design?

#### --distractors--

It focuses on designing for large desktop screens first and then scaling down.

---

It designs primarily for tablet screens before scaling down.

---

It only targets smartphones and ignores tablets or desktops.

#### --answer--

It focuses on designing for mobile devices first, then scaling up for larger screens.

### --question--

#### --text--

Which media query feature is used to detect the screen orientation (landscape or portrait)?

#### --distractors--

`aspect-ratio`

---

`device-width`

---

`max-width`

#### --answer--

`orientation`

### --question--

#### --text--

What does the `prefers-color-scheme` media feature detect?

#### --distractors--

`The type of device used for display`

---

`The screen resolution`

---

`The user's preferred font size`

#### --answer--

`Whether the user prefers a light or dark theme`

### --question--

#### --text--

What does the `orientation` media feature detect?

#### --distractors--

`The width of the screen`

---

`The resolution of the display`

---

`The type of device (tablet, phone, etc.)`

#### --answer--

`Whether the device is in landscape or portrait mode`

### --question--

#### --text--

What is the correct syntax to apply styles for devices with at least 2x pixel density?

#### --distractors--

`@media (resolution: 2x)`

---

`@media screen and (pixel-ratio: 2)`

---

`@media (dpi: 300)`

#### --answer--

`@media screen and (min-resolution: 192dpi)`
