---
id: 66ed903cf45ce3ece4053ebe
title: Semantic HTML Quiz
challengeType: 8
dashedName: quiz-semantic-html
---

# --description--

To pass the quiz, you must correctly answer at least 18 of the 20 questions below.

# --quizzes--

## --quiz--

### --question--

#### --text--

What is presentational HTML?

#### --distractors--

Presentational HTML controls how data is stored on the server.

---

Presentational HTML determines the website's overall layout and navigation structure.

---

Presentational HTML is used for embedding multimedia content.

#### --answer--

Presentational HTML uses elements to control the appearance of content, rather than its meaning or structure.

### --question--

#### --text--

What is the role of the `pre` element?

#### --distractors--

It is used to represent a placeholder inside a web component.

---

It is used to display an indicator showing the completion progress of a task.

---

It is used to convey seriousness or strong importance.

#### --answer--

It is used to represent preformatted text.

### --question--

#### --text--

What is the role of the `h1` element?

#### --distractors--

It is used to group multiple heading elements on the page.

---

It serves as a container for the meta data in the HTML document.

---

It represents the root or top level element for the HTML document.

#### --answer--

It defines the main heading of a webpage, indicating its primary topic.

### --question--

#### --text--

What is the role of the `address` element?

#### --distractors--

It specifies the font size for the main content.

---

It creates a navigation menu for the website.

---

It formats text as superscript.

#### --answer--

It is used to represent contact information for a section on a web page.

### --question--

#### --text--

Which of the following elements holds no semantic meaning?

#### --distractors--

`article`

---

`main`

---

`footer`

#### --answer--

`div`

### --question--

#### --text--

Which of the following elements is used to represent a specific moment in time?

#### --distractors--

`output`

---

`ins`

---

`div`

#### --answer--

`time`

### --question--

#### --text--

What is a typical use case of the `ruby` element?

#### --distractors--

It specifies the document's character encoding.

---

It inserts a table for displaying tabular data.

---

It embeds a video or audio player in the document.

#### --answer--

It is used to show the pronunciation of East Asian characters.

### --question--

#### --text--

Which element is used to highlight keywords in summaries or product names in reviews?

#### --distractors--

`ruby`

---

`table`

---

`template`

#### --answer--

`b`

### --question--

#### --text--

What is the role of the `u` element?

#### --distractors--

It styles text with custom fonts.

---

It specifies the document's character encoding.

---

It creates a dropdown menu for selecting options.

#### --answer--

It is used to represent inline text that has non-textual annotation applied.

### --question--

#### --text--

Which of the following elements is used to represent an extended quotation?

#### --distractors--

`textarea`

---

`sup`

---

`article`

#### --answer--

`blockquote`

### --question--

#### --text--

Which of the following elements is used to provide a description, or definition for the term inside a description list?

#### --distractors--

`dt`

---

`dl`

---

`div`

#### --answer--

`dd`

### --question--

#### --text--

Which of the following elements is typically used with the `code` element?

#### --distractors--

`ins`

---

`summary`

---

`div`

#### --answer--

`pre`

### --question--

#### --text--

Which of the following attributes is used to translate dates and times into a machine-readable format?

#### --distractors--

`alt`

---

`rel`

---

`accept`

#### --answer--

`datetime`

### --question--

#### --text--

Why is it important to not skip heading levels?

#### --distractors--

Skipping heading levels improves website design aesthetics.

---

Skipping heading levels makes text appear in different colors.

---

Skipping heading levels enhances page loading speed.

#### --answer--

Skipping heading levels can confuse screen readers and hinder content accessibility by disrupting the logical content hierarchy.

### --question--

#### --text--

Which of the following is a deprecated presentational HTML element?

#### --distractors--

`div`

---

`footer`

---

`article`

#### --answer--

`font`

### --question--

#### --text--

Which of the following elements is used to represent navigation links?

#### --distractors--

`figure`

---

`div`

---

`section`

#### --answer--

`nav`

### --question--

#### --text--

Which of the following elements represents a description term inside a description list?

#### --distractors--

`dd`

---

`dfn`

---

`del`

#### --answer--

`dt`

### --question--

#### --text--

What is the role of the `i` element?

#### --distractors--

It is used to represent text that has been marked for reference purposes.

---

It is used to provide a caption or legend for disclosure boxes.

---

It is used to format numerical data and sort it from smallest to largest.

#### --answer--

It is used to represent idiomatic text, technical terms, and taxonomical designations.

### --question--

#### --text--

Which of the following elements is used to emphasize text?

#### --distractors--

`anchor`

---

`div`

---

`optgroup`

#### --answer--

`em`

### --question--

#### --text--

Which of the following attributes is used to specify the source or reference of the quoted content for a blockquote?

#### --distractors--

`alt`

---

`class`

---

`lang`

#### --answer--

`cite`

## --quiz--

### --question--

#### --text--

Which of the following is NOT an example of a presentational HTML element?

#### --distractors--

`font`

---

`center`

---

`big`

#### --answer--

`article`

### --question--

#### --text--

Which of the following elements is used to represent a single line of code in HTML?

#### --distractors--

`codes`

---

`codecs`

---

`coding`

#### --answer--

`code`

### --question--

#### --text--

What is the difference between the `strong` and `b` elements?

#### --distractors--

The `b` element is used to emphasize the importance of the text while the `strong` is used to highlight alternative voice or mood.

---

The `strong` element is used to highlight alternative voice or mood while the `b` element emphasizes text that is crucial, or urgent.

---

The `strong` element is commonly used to highlight keywords in summaries while the `b` element emphasizes text that is crucial, or urgent.

#### --answer--

The `b` element is commonly used to highlight keywords in summaries while the `strong` element emphasizes text that is crucial, or urgent.

### --question--

#### --text--

Which of the following is the correct way to use to emphasize a piece of text?

#### --distractors--

```html
<p>
  Never give up on <emphasis>your</emphasis> dreams.
</p>
```

---

```html
<p>
  Never give up on <emphasize>your</emphasize> dreams.
</p>
```

---

```html
<p>
  Never give up on <e>your</e> dreams.
</p>
```

#### --answer--

```html
<p>
  Never give up on <em>your</em> dreams.
</p>
```

### --question--

#### --text--

Which of the following elements is used to bring attention to text that is not important for the meaning of the content?

#### --distractors--

`em`

---

`small`

---

`strong`

#### --answer--

`b`

### --question--

#### --text--

When should you use CSS instead of the `i` or `em` elements?

#### --distractors--

When the text has a special purpose or meaning in the paragraph.

---

When the text is an idiomatic expression.

---

When the text needs to be emphasized for importance.

#### --answer--

When you want to display text in italics for presentational purposes only.

### --question--

#### --text--

Which of the following elements is used to represent a span of inline text which should be rendered in a way that indicates that it has a non-textual annotation?

#### --distractors--

`sub`

---

`span`

---

`s`

#### --answer--

`u`

### --question--

#### --text--

Which of the following is the correct way to represent a section quoted from another source?

#### --distractors--

```html
<cite cite="https://www.freecodecamp.org/news/learn-to-code-book/">
  "Can you imagine what it would be like to be a successful developer? To have built software systems that people rely upon?"
</cite>
```

---

```html
<block cite="https://www.freecodecamp.org/news/learn-to-code-book/">
  "Can you imagine what it would be like to be a successful developer? To have built software systems that people rely upon?"
</block>
```

---

```html
<quotes cite="https://www.freecodecamp.org/news/learn-to-code-book/">
  "Can you imagine what it would be like to be a successful developer? To have built software systems that people rely upon?"
</quotes>
```

#### --answer--

```html
<blockquote cite="https://www.freecodecamp.org/news/learn-to-code-book/">
  "Can you imagine what it would be like to be a successful developer? To have built software systems that people rely upon?"
</blockquote>
```

### --question--

#### --text--

Which of the following elements is used to mark up the title of a referenced creative work like a book?

#### --distractors--

`figure`

---

`article`

---

`div`

#### --answer--

`cite`

### --question--

#### --text--

What is the role of the `q` element?

#### --distractors--

It represents a fragment of computer code.

---

It represents superscript text.

---

It represents a date and/or time.

#### --answer--

It represents a short inline quotation.

### --question--

#### --text--

Which of the following is used to display abbreviations and acronyms in HTML?

#### --distractors--

```html
<p><acronym>HTML</acronym> is the foundation of the web.</p>
```

---

```html
<p><acr>HTML</acr> is the foundation of the web.</p>
```

---

```html
<p><abbreviation>HTML</abbreviation> is the foundation of the web.</p>
```

#### --answer--

```html
<p><abbr>HTML</abbr> is the foundation of the web.</p>
```

### --question--

#### --text--

What is the role of the `title` attribute inside of the abbreviation element?

#### --distractors--

It is used to represent subscript text.

---

It is used to represent a span of inline text which should be rendered in a way that indicates that it has a non-textual annotation.

---

It is used to annotate text with pronunciation or meaning explanations.

#### --answer--

It is used to help users understand what this acronym means.

### --question--

#### --text--

Which of the following elements is used to represent contact information on the web page?

#### --distractors--

`location`

---

`residence`

---

`contact`

#### --answer--

`address`

### --question--

#### --text--

What is the role of the `datetime` attribute in the `time` element?

#### --distractors--

It is used to display an alert to show the current date and time.

---

It is used to set the time to a 12-hour clock format.

---

It is used to set the time to military format.

#### --answer--

It is used to represent dates and times in a machine-readable format. 

### --question--

#### --text--

Which of the following is used to display a piece of text as a superscript?

#### --distractors--

```html
<p>2<superscript>2</superscript> (2 squared) is 4.</p>
```

---

```html
<p>2<s>2</s> (2 squared) is 4.</p>
```

---

```html
<p>2<super>2</super> (2 squared) is 4.</p>
```

#### --answer--

```html
<p>2<sup>2</sup> (2 squared) is 4.</p>
```

### --question--

#### --text--

Which of the following is NOT a common use case for using the subscript (`sub`) element?

#### --distractors--

variable subscripts

---

footnotes

---

chemical formulas

#### --answer--

displaying dates

### --question--

#### --text--

What is the role of the `s` element?

#### --distractors--

It is used to style a piece of text with a raised baseline.

---

It is used to indicate text for the ruby annotation.

---

It is used to represent inline text that has non-textual annotation applied.

#### --answer--

It is used to represent when text is no longer accurate or relevant.

### --question--

#### --text--

Which of the following is NOT a common use case for using the superscript element?

#### --distractors--

exponents

---

superior lettering

---

ordinal numbers

#### --answer--

chemical formulas

### --question--

#### --text--

What is the role of the `ruby` element?

#### --distractors--

It represents a list of term-description groupings.

---

It represents the term being defined in a description list.

---

It represents preformatted text for code examples.

#### --answer--

It represents small text shown above or below the main text.

### --question--

#### --text--

Which of the following elements is used as a fallback for browsers lacking support for displaying ruby annotations?

#### --distractors--

`rub`

---

`pr`

---

`r`

#### --answer--

`rp`

## --quiz--

### --question--

#### --text--

What is the purpose of the `header` element in HTML?

#### --distractors--

It defines the main content of the document.

---

It represents a section with navigation links.

---

It defines a sidebar for the document.

#### --answer--

It marks the header of a document or section.

### --question--

#### --text--

Which element is used to contain the main content of a web page?

#### --distractors--

`nav`

---

`article`

---

`section`

#### --answer--

`main`

### --question--

#### --text--

What is the correct use of the `nav` element?

#### --distractors--

To define the header of a document.

---

To display metadata about a webpage.

---

To contain the main content of the page.

#### --answer--

To represent a section with navigation links.

### --question--

#### --text--

Which element is used to mark text with stress emphasis?

#### --distractors--

`mark`

---

`i`

---

`b`

#### --answer--

`em`

### --question--

#### --text--

What is the purpose of the `figure` element?

#### --distractors--

To define the main content of the page.

---

To group multiple articles together.

---

To represent a section with navigation links.

#### --answer--

To contain illustrations and diagrams.

### --question--

#### --text--

Which element is used to represent a short inline quotation?

#### --distractors--

`blockquote`

---

`span`

---

`cite`

#### --answer--

`q`

### --question--

#### --text--

What is the purpose of the `time` element?

#### --distractors--

To define a script execution time.

---

To define the main content of the page.

---

To highlight important text.

#### --answer--

To represent a date or time value.

### --question--

#### --text--

Which element is used to represent an abbreviation or acronym?

#### --distractors--

`var`

---

`cite`

---

`code`

#### --answer--

`abbr`

### --question--

#### --text--

What is the purpose of the `blockquote` element?

#### --distractors--

To represent a short inline quotation.

---

To define a paragraph with larger text.

---

To define the main content of the page.

#### --answer--

To represent a section quoted from another source.

### --question--

#### --text--

Which element is used to represent a list of term-description groupings?

#### --distractors--

`ul`

---

`table`

---

`ol`

#### --answer--

`dl`

### --question--

#### --text--

What is the purpose of the `cite` element?

#### --distractors--

To represent a short inline quotation.

---

To represent a highlighted word.

---

To define the main content of the page.

#### --answer--

To attribute the source of a referenced work.

### --question--

#### --text--

Which element is used to represent superscript text?

#### --distractors--

`sub`

---

`abbr`

---

`strong`

#### --answer--

`sup`

### --question--

#### --text--

What is the purpose of the `address` element?

#### --distractors--

To define the main content of the page.

---

To define the address of a hyperlink.

---

To represent a section with navigation links.

#### --answer--

To represent contact information for the author or owner of a webpage.

### --question--

#### --text--

Which element is used to represent preformatted text?

#### --distractors--

`code`

---

`samp`

---

`blockquote`

#### --answer--

`pre`

### --question--

#### --text--

What is the purpose of the `strong` element?

#### --distractors--

To mark text with stress emphasis.

---

To make text italic.

---

To highlight text that is not important.

#### --answer--

To mark text with strong importance.

### --question--

#### --text--

Which element is used to represent a fragment of computer code?

#### --distractors--

`pre`

---

`var`

---

`blockquote`

#### --answer--

`code`

### --question--

#### --text--

What is the purpose of the `abbr` element?

#### --distractors--

To represent a date or time value.

---

To add tooltips to text.

---

To represent a short inline quotation.

#### --answer--

To represent an abbreviation or acronym.

### --question--

#### --text--

Which element is used to represent a long quotation from another source?

#### --distractors--

`q`

---

`mark`

---

`cite`

#### --answer--

`blockquote`

### --question--

#### --text--

What is the purpose of the `dl` element?

#### --distractors--

To represent a list of items.

---

To define a list of numbered items.

---

To represent a section with navigation links.

#### --answer--

To represent a list of term-description groupings.

### --question--

#### --text--

Which element is used to represent subscript text?

#### --distractors--

`sup`

---

`small`

---

`strong`

#### --answer--

`sub`
