---
id: 66ed9043f45ce3ece4053ebf
title: Styling Forms Quiz
challengeType: 8
dashedName: quiz-styling-forms
---

# --description--

To pass the quiz, you must correctly answer at least 9 of the 10 questions below.

# --quizzes--

## --quiz--

### --question--

#### --text--

What is a common issue for styling the `datetime-local` input type?

#### --distractors--

It does not work with the `float` property.

---

It is impossible to make it responsive.

---

It does not work with `rem` units.

#### --answer--

The input format is different across browsers.

### --question--

#### --text--

Which of the following is considered best practice for styling text inputs?

#### --distractors--

Text input font sizes need to be set with `em` units and colors should be a light gray.

---

Text input sizes should only use dark green borders on focus and the text color should be dark gray.

---

Text input font colors need to be light colors and the size should only be set using the `px` unit.

#### --answer--

Text input fonts need to be adequately sized, and the color needs to have sufficient contrast with the background.

### --question--

#### --text--

How should the error state styling relate to the focus state styling?

#### --distractors--

They should be identical for consistency.

---

The error state should be less visible to avoid alarming users.

---

The error state should be animated while the focus state should be static.

#### --answer--

The error state should be distinct from the focus state.

### --question--

#### --text--

What is a best practice for styling inputs in a focused state?

#### --distractors--

It is important to use only light gray borders for focused inputs.

---

It is important to only use dark red borders for focused inputs.

---

It is important to remove any noticeable indicator.

#### --answer--

It is important to preserve a noticeable indicator.

### --question--

#### --text--

What is a best practice for styling inputs in an error state?

#### --distractors--

Increase the font size for the input text to `3rem`.

---

Set the input to `display: none;` so it is removed from the page.

---

Set the input to be disabled so users can no longer interact with it.

#### --answer--

Provide a visual indicator with a message so users know that something is incorrect and needs to be fixed.

### --question--

#### --text--

Why is it important to use descriptive placeholder text in form inputs?

#### --distractors--

It helps to pre-fill the form for the user.

---

It automatically validates the input as the user types.

---

It hides the input label, reducing visual clutter.

#### --answer--

It provides users with guidance on the expected input format.

### --question--

#### --text--

What is WebKit?

#### --distractors--

It is a browser engine that ensures that there are no validation errors in your CSS.

---

It is a special CSS property used in CSS Grid.

---

It is a special CSS property used in CSS flexbox.

#### --answer--

It is a browser engine that displays webpages.

### --question--

#### --text--

When is it appropriate to use `appearance: none;` for form elements?

#### --distractors--

To remove form elements completely from the DOM and page.

---

To hide form elements from those who use assistive technologies like screen readers.

---

To remove only default colors that are applied to the form elements and use your own.

#### --answer--

To remove some of the default styles that are applied to the form elements.

### --question--

#### --text--

What are some considerations when working with `appearance: none;` on form elements?

#### --distractors--

It is important to preserve hovered and submit indicators on interactive elements.

---

It is important to only use `appearance: none;` when you want to apply different styles for the Safari browser.

---

It is important to use `appearance: none;` when you need to completely remove a form element from the page.

#### --answer--

It is important to preserve focus and error indicators on interactive elements.

### --question--

#### --text--

Which type of form elements are commonly styled using `appearance: none;` to remove their default look?

#### --distractors--

`label` elements.

---

`div` elements.

---

`span` elements.

#### --answer--

`input` elements.
