---
id: 671a87e6dcef5b5bd765e5ed
title: Computer Basics Review
challengeType: 31
dashedName: review-computer-basics
---

# --description--

## Understanding Computer, Internet and Developer Tooling Basics

- **Motherboard**: holds all of the memory, connectors, and hard drives that are needed to run the computer. It serves as the main circuit board for the computer.
- **Central Processing Unit(CPU)**: a processor that is responsible for executing instructions and performing calculations. 
- **Random Access Memory(RAM)**: a temporary storage location for the computer's CPU.
- **Hard Disk Drive(HDD)**: a permanent storage location that is used to store data even when the computer is turned off.
- **Solid State Drive(SSD)**: non-volatile flash memory and can be used in place of a hard drive.
- **Power Supply Unit(PSU)**: responsible for converting the electricity from the wall outlet into a form that the computer can use.
- **Graphics Processing Unit(GPU)**: responsible for rendering visuals on the computer screen.
- **Different Types of Internet Service Providers**: An Internet Service Provider (ISP) is a company that provides access to the internet. There are different types of ISPs, including dial-up, DSL, cable, fiber-optic, and satellite.
- **Safe Ways to Sign Into Your Computer**: Examples of safe ways to sign into your computer include using a strong password, enabling two-factor authentication, and using a password manager.
- **Integrated Development Environment (IDE)**: a tool that helps developers write, test and debug code in an efficient manner. 
- **Code Editor**: a tool that developers use to write and debug code. 
- **Git**: a popular version control system that allows developers to track changes in their code and collaborate with others.
- **Cloud-based Hosting Services for repositories**: A repository is a storage location for project files and version history. Popular cloud-based hosting services for repositories include GitHub, GitLab, and Bitbucket.
- **Package Managers**: tools that help developers simplify the process of adding, updating, and removing libraries and project dependencies. Examples include npm, pip, and Maven.
- **Testing Libraries and Frameworks**: Testing is done in software to ensure that the code works as expected. Examples of testing libraries and frameworks include Jest, PHPUnit, and JUnit.

## Working With Files, File Systems and Media Formats

- **Best practices for naming files**: You will want to name your files in a way that is easy to understand and maintain. For example, `about-us.html` is a more descriptive name than `page1.html`.
- **root directory**: top-level directory in a file system. Directory is another name for a folder.
- **Markdown**: a markup language commonly used for documentation and `README` files. A `README` file is a file that contains information about a project, such as how to install and use it.
- **`index.html`**: represents the default page that is displayed when a user visits a website.
- **Create, Move, and Delete files and folders using Explorer/Finder**: Explorer is the file manager in Windows, and Finder is the file manager in macOS. You can use these tools to create, move, and delete files and folders.
- **Searching for files and folders**: You can use the search functionality in Explorer or Finder to find files and folders on your computer.
- **HTML, CSS and JS File Types**: `.html` file extension is used for HTML files, `.css` for CSS files, and `.js` for JavaScript files.
- **Common Image and Graphic Formats**: `JPEG` and `PNG` are common image file formats. `GIF` is another common image file format that supports animation. `SVG` is a file format for vector graphics.
- **Common Audio and Video Formats**: The `MP3` format is commonly used for audio files. The `MP4` format is commonly used for video files. The `MOV` format was developed by Apple and is commonly used for video files.
- **Common Font Formats**: The `TTF` format is commonly used for TrueType fonts. The `WOFF` format is commonly used for web fonts. The successor to WOFF is `WOFF2`, which provides better compression.
- **ZIP**: a file format that is used to compress files and folders. 

## Browsing the Web Effectively

- **What is a Web browser?**: a software application that allows users to access and view websites on the internet.
- **What is a Search Engine**: a tool that allows users to search for information on the internet. Examples include Google, Bing, and Yahoo.
- **Common web browsers**: A few examples of common web browsers include Google Chrome, Mozilla Firefox, and Microsoft Edge.
- **Common Search Strategies**: You can use `site:` followed by the URL of a website to search for content on that website. You can use `filetype:` followed by a file extension to search for files of that type. You can prefix a search term with a minus sign to exclude results containing that term. You can prefix a search term with a plus sign to include results containing that term.

# --assignment--

Review the Computer Basics topics and concepts.
