---
id: 671a8f8350c20a7439015c98
title: CSS Relative and Absolute Units Review
challengeType: 31
dashedName: review-css-relative-and-absolute-units
---

# --description--

## Absolute Units

- **`px` (Pixels)**: This absolute unit is a fixed-size unit of measurement in CSS. It is the most common absolute unit and provides precise control over dimensions. `1px` is always equal to 1/96th of an inch.
- **`in` (Inch)**: This absolute unit is equal to 96px.
- **`cm` (Centimeters)**: This absolute unit is equal to 25.2/64 of an inch.
- **`mm` (Millimeters)**: This absolute unit is equal to 1/10th of a centimeter.
- **`q` (Quarter-Millimeters)**: This absolute unit is equal to 1/40th of a centimeter.
- **`pc` (Picas)**: This absolute unit is equal to 1/6th of an inch.
- **`pt` (Points)**: This absolute unit is equal to 1/72th of an inch.

## Relative Units

- **Percentages**: These relative units allow you to define sizes, dimensions, and other properties as a proportion of their parent element. For example, if you set `width: 50%;` on an element, it will occupy half the width of its parent container. 
- **`em` Unit**: These units are relative to the font size of the element. If you are using `ems` for the `font-size` property, the size of the text will be relative to the font size of the parent element.
- **`rem` Unit**: These units are relative to the font size of the root element, which is the `html` element. 
- **`vh` Unit**: `vh` stands for `"viewport height"` and `1vh` is equal to 1% of the viewport's height.
- **`vw` Unit**: `vw` stands for `"viewport width"` and `1vw` is equal to 1% of the viewport's width.

## `calc` Function

- **`calc()` Function**: With the `calc()` function, you can perform calculations directly within your stylesheets to determine property values dynamically. This means that you can create flexible and responsive user interfaces by calculating dimensions based on the viewport size or other elements.

# --assignment--

Review the CSS Relative and Absolute Units topics and concepts.
