---
id: 663d0ab797cb716189ffcc0a
title: Step 1
challengeType: 0
dashedName: step-1
demoType: onLoad
---

# --description--

The first step is to build out the function that will generate a random choice for the computer.

The `getRandomComputerResult` function will be used to get the computer's choice. Inside that function, you should see an `options` array with `"Rock"`, `"Paper"`, and `"Scissors"`. 

Your task is to complete the `getRandomComputerResult` function so that it returns a random option from the `options` array.

**Tips**

- You can use `Math.random()` and `Math.floor()` to help you get a random whole number. This will represent the index number for the `options` array.
- You can use the random index to access the option from the `options` array.


# --hints--

Your `getRandomComputerResult` function should return a string.

```js
assert.isString(getRandomComputerResult());
```

Your `getRandomComputerResult` function should return one of the options in the `options` array.

```js
assert.include(["Rock", "Paper", "Scissors"], getRandomComputerResult());
```

Your `getRandomComputerResult` function should return a random option each time.

```js
const results = new Set();

for (let i = 0; i < 50; i++) {
  results.add(getRandomComputerResult());
}

assert.hasAllKeys(results, ["Rock", "Paper", "Scissors"]);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Rock, Paper, Scissors game</title>
    <link rel="stylesheet" href="./styles.css" />
  </head>
  <body>
    <h1>Let's play Rock, Paper, Scissors!</h1>
    <main>
      <details class="rules-container">
        <summary>Rules to the game</summary>

        <p>You will be playing against the computer.</p>
        <p>You can choose between Rock, Paper, and Scissors.</p>
        <p>The first one to three points wins.</p>

        <p>Here are the rules to getting a point in the game:</p>
        <ul>
          <li>Rock beats Scissors</li>
          <li>Scissors beats Paper</li>
          <li>Paper beats Rock</li>
        </ul>
        <p>
          If the player and computer choose the same option (Ex. Paper and
          Paper), then no one gets the point.
        </p>
      </details>

      <div class="score-container">
        <strong
          >Player Score: <span class="score" id="player-score">0</span></strong
        >
        <strong
          >Computer Score:
          <span class="score" id="computer-score">0</span></strong
        >
      </div>

      <section class="options-container">
        <h2>Choose an option:</h2>
        <div class="btn-container">
          <button id="rock-btn" class="btn">Rock</button>
          <button id="paper-btn" class="btn">Paper</button>
          <button id="scissors-btn" class="btn">Scissors</button>
        </div>
      </section>

      <div class="results-container">
        <p id="results-msg"></p>
        <p id="winner-msg"></p>
        <button class="btn" id="reset-game-btn">Play again?</button>
      </div>
    </main>
    <script src="./script.js"></script>
  </body>
</html>

```

```css
*,
*::before,
*::after {
  margin: 0;
  padding: 0;
  box-sizing: border-box;
}

:root {
  --very-dark-blue: #0a0a23;
  --white: #ffffff;
  --yellow: #f1be32;
  --golden-yellow: #feac32;
}

body {
  background-color: var(--very-dark-blue);
  text-align: center;
  color: var(--white);
}

h1 {
  margin: 15px 0 20px;
}

.btn {
  cursor: pointer;
  width: 100px;
  margin: 10px;
  color: var(--very-dark-blue);
  background-color: var(--golden-yellow);
  background-image: linear-gradient(#fecc4c, #ffac33);
  border-color: var(--golden-yellow);
  border-width: 3px;
}

.btn:hover {
  background-image: linear-gradient(#ffcc4c, #f89808);
}

.rules-container {
  padding: 10px 0;
  margin: auto;
  border-radius: 15px;
  border: 5px solid var(--yellow);
  background-color: var(--white);
  color: var(--very-dark-blue);
}

.rules-container ul {
  list-style-type: none;
}

.rules-container p {
  margin: 10px 0;
}

@media (min-width: 760px) {
  .rules-container {
    width: 60%;
  }
}

.score-container {
  display: flex;
  justify-content: space-around;
  margin: 30px 0;
  font-size: 1.2rem;
}

.score {
  font-weight: 500;
}

.results-container {
  font-size: 1.3rem;
  margin: 15px 0;
}

#winner-msg {
  margin-top: 25px;
}

#reset-game-btn {
  display: none;
  margin: 20px auto;
}

```

```js
--fcc-editable-region--
function getRandomComputerResult() {
  const options = ["Rock", "Paper", "Scissors"];

}
console.log(getRandomComputerResult());
--fcc-editable-region--
```
