---
id: 663d2f8056542a8066fd6cc6
title: Step 3
challengeType: 0
dashedName: step-3
---

# --description--

Now it is time to get the results of the round. Complete the `getRoundResults` function. 

If the player wins the round, update the `playerScore` by `1` and return the message `"Player wins! [player's choice] beats [computer's choice]"`.

If the computer and player choose the same option, return the message `"It's a tie! Both chose [player's choice]"`.

If the computer wins the round, update the `computerScore` by `1` and return the message `"Computer wins! [computer's choice] beats [player's choice]"`.

`[computer's choice]` should be replaced with `computerResult` while `[player's choice]` should be replaced with the `userOption`.

**Tips**

- Remember you can use the `hasPlayerWonTheRound` function to check if the player wins the round.
- You can use template literals or regular string concatenation to build the message.


# --hints--

Your `getRoundResults` should return a string.

```js
assert.isString(getRoundResults("Rock"));
```

Your `getRoundResults` function should return the correct message based on who wins the round. If no one wins, the message should say it's a tie.

```js
const result = getRoundResults("Paper")
if(result.startsWith("Player wins!")){
  assert.strictEqual(result, "Player wins! Paper beats Rock")
  assert.isAtLeast(playerScore, 1)
} else if(result.startsWith("Computer wins!")) {
  assert.strictEqual(result, "Computer wins! Scissors beats Paper")
  assert.isAtLeast(computerScore, 1)
} else if(result.startsWith("It's a tie!")){
  assert.strictEqual(result, "It's a tie! Both chose Paper")
}
```


# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Rock, Paper, Scissors game</title>
    <link rel="stylesheet" href="./styles.css" />
  </head>
  <body>
    <h1>Let's play Rock, Paper, Scissors!</h1>
    <main>
      <details class="rules-container">
        <summary>Rules to the game</summary>

        <p>You will be playing against the computer.</p>
        <p>You can choose between Rock, Paper, and Scissors.</p>
        <p>The first one to three points wins.</p>

        <p>Here are the rules to getting a point in the game:</p>
        <ul>
          <li>Rock beats Scissors</li>
          <li>Scissors beats Paper</li>
          <li>Paper beats Rock</li>
        </ul>
        <p>
          If the player and computer choose the same option (Ex. Paper and
          Paper), then no one gets the point.
        </p>
      </details>

      <div class="score-container">
        <strong
          >Player Score: <span class="score" id="player-score">0</span></strong
        >
        <strong
          >Computer Score:
          <span class="score" id="computer-score">0</span></strong
        >
      </div>

      <section class="options-container">
        <h2>Choose an option:</h2>
        <div class="btn-container">
          <button id="rock-btn" class="btn">Rock</button>
          <button id="paper-btn" class="btn">Paper</button>
          <button id="scissors-btn" class="btn">Scissors</button>
        </div>
      </section>

      <div class="results-container">
        <p id="results-msg"></p>
        <p id="winner-msg"></p>
        <button class="btn" id="reset-game-btn">Play again?</button>
      </div>
    </main>
    <script src="./script.js"></script>
  </body>
</html>

```

```css
*,
*::before,
*::after {
  margin: 0;
  padding: 0;
  box-sizing: border-box;
}

:root {
  --very-dark-blue: #0a0a23;
  --white: #ffffff;
  --yellow: #f1be32;
  --golden-yellow: #feac32;
}

body {
  background-color: var(--very-dark-blue);
  text-align: center;
  color: var(--white);
}

h1 {
  margin: 15px 0 20px;
}

.btn {
  cursor: pointer;
  width: 100px;
  margin: 10px;
  color: var(--very-dark-blue);
  background-color: var(--golden-yellow);
  background-image: linear-gradient(#fecc4c, #ffac33);
  border-color: var(--golden-yellow);
  border-width: 3px;
}

.btn:hover {
  background-image: linear-gradient(#ffcc4c, #f89808);
}

.rules-container {
  padding: 10px 0;
  margin: auto;
  border-radius: 15px;
  border: 5px solid var(--yellow);
  background-color: var(--white);
  color: var(--very-dark-blue);
}

.rules-container ul {
  list-style-type: none;
}

.rules-container p {
  margin: 10px 0;
}

@media (min-width: 760px) {
  .rules-container {
    width: 60%;
  }
}

.score-container {
  display: flex;
  justify-content: space-around;
  margin: 30px 0;
  font-size: 1.2rem;
}

.score {
  font-weight: 500;
}

.results-container {
  font-size: 1.3rem;
  margin: 15px 0;
}

#winner-msg {
  margin-top: 25px;
}

#reset-game-btn {
  display: none;
  margin: 20px auto;
}

```

```js
function getRandomComputerResult() {
  const options = ["Rock", "Paper", "Scissors"];
  const randomIndex = Math.floor(Math.random() * options.length);
  return options[randomIndex];
}

let playerScore = 0;
let computerScore = 0;

function hasPlayerWonTheRound(player, computer) {
  return (
    (player === "Rock" && computer === "Scissors") ||
    (player === "Scissors" && computer === "Paper") ||
    (player === "Paper" && computer === "Rock")
  );
}
--fcc-editable-region--
function getRoundResults(userOption) {
  const computerResult = getRandomComputerResult();
 
}

console.log(getRoundResults("Rock"));
console.log("Player Score: ", playerScore, "Computer Score: ", computerScore);
--fcc-editable-region--
```
