---
id: 614396f7ae83f20ea6f9f4b3
title: Step 26
challengeType: 0
dashedName: step-26
---

# --description--

The `.sr-only` text is still visible. There is a common pattern to visually hide text for only screen readers to read. 

This pattern is to set the following CSS properties:

```css
position: absolute;
width: 1px;
height: 1px;
padding: 0;
margin: -1px;
overflow: hidden;
clip: rect(0, 0, 0, 0);
white-space: nowrap;
border: 0;
```

Use the above to define the `.sr-only` CSS rule.

# --hints--

You should use the `.sr-only` selector.

```js
assert.exists(new __helpers.CSSHelp(document).getStyle('.sr-only'));
```

You should give the `.sr-only` a `position` of `absolute`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('.sr-only')?.position, 'absolute');
```

You should give the `.sr-only` a `width` of `1px`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('.sr-only')?.width, '1px');
```

You should give the `.sr-only` a `height` of `1px`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('.sr-only')?.height, '1px');
```

You should give the `.sr-only` a `padding` of `0`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('.sr-only')?.padding, '0px');
```

You should give the `.sr-only` a `margin` of `-1px`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('.sr-only')?.margin, '-1px');
```

You should give the `.sr-only` an `overflow` of `hidden`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('.sr-only')?.overflow, 'hidden');
```

You should give the `.sr-only` a `clip` of `rect(0, 0, 0, 0)`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('.sr-only')?.clip, 'rect(0px, 0px, 0px, 0px)');
```

You should give the `.sr-only` a `white-space` of `nowrap`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('.sr-only')?.whiteSpace, 'nowrap');
```

You should give the `.sr-only` a `border` of `0`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('.sr-only')?.borderWidth, '0px');
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta name="description" content="freeCodeCamp Accessibility Quiz practice project" />
    <title>Accessibility Quiz</title>
    <link rel="stylesheet" href="styles.css" />
  </head>
  <body>
    <header>
      <img id="logo" alt="freeCodeCamp" src="https://cdn.freecodecamp.org/platform/universal/fcc_primary.svg">
      <h1>HTML/CSS Quiz</h1>
      <nav>
        <ul>
          <li><a href="#student-info">INFO</a></li>
          <li><a href="#html-questions">HTML</a></li>
          <li><a href="#css-questions">CSS</a></li>
        </ul>
      </nav>
    </header>
    <main>
      <form method="post" action="https://freecodecamp.org/practice-project/accessibility-quiz">
        <section role="region" aria-labelledby="student-info">
          <h2 id="student-info">Student Info</h2>
          <div class="info">
            <label for="student-name">Name:</label>
            <input type="text" name="student-name" id="student-name" />
          </div>
          <div class="info">
            <label for="student-email">Email:</label>
            <input type="email" name="student-email" id="student-email" />
          </div>
          <div class="info">
            <label for="birth-date">Date of Birth:</label>
            <input type="date" name="birth-date" id="birth-date" />
          </div>
        </section>
        <section role="region" aria-labelledby="html-questions">
          <h2 id="html-questions">HTML</h2>
          <div class="question-block">
            <h3><span class="sr-only">Question</span>1</h3>
            <fieldset class="question"></fieldset>
          </div>
          <div class="question-block">
            <h3><span class="sr-only">Question</span>2</h3>
            <fieldset class="question"></fieldset>
          </div>
        </section>
        <section role="region" aria-labelledby="css-questions">
          <h2 id="css-questions">CSS</h2>
        </section>
      </form>
    </main>
  </body>
</html>

```

```css
body {
  background: #f5f6f7;
  color: #1b1b32;
  font-family: Helvetica;
  margin: 0;
}

header {
  width: 100%;
  height: 50px;
  background-color: #1b1b32;
  display: flex;
}

#logo {
  width: max(10rem, 18vw);
  background-color: #0a0a23;
  aspect-ratio: 35 / 4;
  padding: 0.4rem;
}

h1 {
  color: #f1be32;
  font-size: min(5vw, 1.2em);
}

nav {
  width: 50%;
  max-width: 300px;
  height: 50px;
}

nav > ul {
  display: flex;
  justify-content: space-evenly;
}

h1,
h2 {
  font-family: Verdana, Tahoma;
}

h2 {
  border-bottom: 4px solid #dfdfe2;
}

```

```css
body {
  background: #f5f6f7;
  color: #1b1b32;
  font-family: Helvetica;
  margin: 0;
}

header {
  width: 100%;
  height: 50px;
  background-color: #1b1b32;
  display: flex;
}

#logo {
  width: max(10rem, 18vw);
  background-color: #0a0a23;
  aspect-ratio: 35 / 4;
  padding: 0.4rem;
}

h1 {
  color: #f1be32;
  font-size: min(5vw, 1.2em);
}

nav {
  width: 50%;
  max-width: 300px;
  height: 50px;
}

nav > ul {
  display: flex;
  justify-content: space-evenly;
}

h1,
h2 {
  font-family: Verdana, Tahoma;
}

h2 {
  border-bottom: 4px solid #dfdfe2;
}

--fcc-editable-region--

--fcc-editable-region--

```
